/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.AbstractPiglinAi;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BowAttack;
import tallestred.piglinproliferation.common.entities.ai.behaviors.MoveAroundPiglins;
import tallestred.piglinproliferation.common.entities.ai.behaviors.ShootTippedArrow;
import tallestred.piglinproliferation.common.entities.ai.behaviors.StopHoldingItemAfterAdmiring;
import tallestred.piglinproliferation.common.entities.ai.behaviors.SwimOnlyOutOfLava;
import tallestred.piglinproliferation.common.entities.ai.behaviors.ThrowPotionAtSelfTask;
import tallestred.piglinproliferation.common.entities.ai.behaviors.ThrowPotionAtTargetTask;
import tallestred.piglinproliferation.common.loot.PPLoot;
import tallestred.piglinproliferation.util.CodeUtilities;

public class PiglinAlchemistAi
extends AbstractPiglinAi<PiglinAlchemist> {
    public static PiglinAlchemistAi INSTANCE = new PiglinAlchemistAi();

    @Override
    public void initActivities(PiglinAlchemist piglin, Brain<PiglinAlchemist> brain) {
        super.initActivities(piglin, brain);
        PiglinAlchemistAi.initThrowPotionActivity(brain, piglin);
    }

    @Override
    protected List<BehaviorControl<? super PiglinAlchemist>> coreBehaviors(PiglinAlchemist piglin) {
        return CodeUtilities.castElementsToList(new Object[]{new LookAtTargetSink(45, 90), new MoveToTargetSink(), InteractWithDoor.create(), new SwimOnlyOutOfLava(0.8f), PiglinAi.avoidZombified(), StopHoldingItemAfterAdmiring.create(this, PPLoot.ALCHEMIST_BARTER), StartAdmiringItemIfSeen.create((int)120), StartCelebratingIfTargetDead.create((int)300, PiglinAi::wantsToDance), StopBeingAngryIfTargetDead.create(), PiglinAlchemistAi.generatePotionAi(piglin), new ShootTippedArrow(1.5, 15.0f, 20, PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)Potions.STRONG_HEALING), p -> p.isAlive() && p.getHealth() < p.getMaxHealth())});
    }

    @Override
    protected RunOne<PiglinAlchemist> idleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of(MoveAroundPiglins.moveAroundPiglins(0.6f, true), (Object)2), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.PIGLIN, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(PiglinAi::doesntSeeAnyPlayerHoldingLovedItem, (OneShot)SetWalkTargetFromLookTarget.create((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    @Override
    protected List<BehaviorControl<? super PiglinAlchemist>> fightBehaviors(PiglinAlchemist piglin) {
        List<BehaviorControl<? super PiglinAlchemist>> list = super.fightBehaviors(piglin);
        list.add((BehaviorControl<? super PiglinAlchemist>)new BowAttack((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 1.5, 15.0f, 20));
        return list;
    }

    private static void initThrowPotionActivity(Brain<PiglinAlchemist> brain, PiglinAlchemist piglin) {
        brain.addActivityAndRemoveMemoryWhenStopped((Activity)PPActivities.THROW_POTION_ACTIVITY.get(), 10, ImmutableList.of((Object)((Object)new ShootTippedArrow(1.5, 15.0f, 20, PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)Potions.STRONG_HEALING), piglin2 -> piglin2.isAlive() && piglin2.getHealth() < piglin2.getMaxHealth())), PiglinAlchemistAi.generatePotionAi(piglin)), (MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
    }

    private static RunOne<PiglinAlchemist> generatePotionAi(PiglinAlchemist piglinAlchemist) {
        return new RunOne((List)ImmutableList.of((Object)Pair.of(new ThrowPotionAtTargetTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.FIRE_RESISTANCE), LivingEntity::isAlive, piglin -> piglin.isAlive() && piglin.isOnFire()), (Object)1), (Object)Pair.of(new ThrowPotionAtTargetTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.STRONG_REGENERATION), LivingEntity::isAlive, piglin -> {
            List list = piglinAlchemist.level().getEntitiesOfClass(AbstractPiglin.class, piglinAlchemist.getBoundingBox().inflate(10.0, 3.0, 10.0));
            if (!list.isEmpty()) {
                for (AbstractPiglin piglin1 : list) {
                    if (piglin1.getTarget() == null && piglinAlchemist.getTarget() == null) continue;
                    return list.size() > 2 && piglin.isAlive() && piglin.getHealth() < piglin.getMaxHealth();
                }
            }
            return piglin.isAlive() && piglin.getHealth() < piglin.getMaxHealth();
        }), (Object)1), (Object)Pair.of(new ThrowPotionAtTargetTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.STRONG_HEALING), LivingEntity::isAlive, piglin -> {
            List list = piglinAlchemist.level().getEntitiesOfClass(AbstractPiglin.class, piglinAlchemist.getBoundingBox().inflate(10.0, 3.0, 10.0));
            if (!list.isEmpty()) {
                for (AbstractPiglin piglin1 : list) {
                    if (piglin1.getTarget() == null && piglinAlchemist.getTarget() == null) continue;
                    return piglin.isAlive() && piglin.getHealth() < piglin.getMaxHealth() && piglinAlchemist.beltInventory.noneMatch(stack -> CodeUtilities.potionContents(stack).potion().orElse(Potions.WATER) == Potions.STRONG_REGENERATION) && list.size() > 2;
                }
            }
            return piglin.isAlive() && piglin.getHealth() < piglin.getMaxHealth();
        }), (Object)1), (Object)Pair.of((Object)new ThrowPotionAtTargetTask<PiglinAlchemist>(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.STRONG_STRENGTH), LivingEntity::isAlive, piglin -> piglin.isAlive() && piglin.getTarget() != null && piglin.getHealth() < piglin.getMaxHealth() / 2.0f && !piglin.isHolding(itemStack -> {
            Item itemInStack = itemStack.getItem();
            return itemInStack instanceof ProjectileWeaponItem;
        })){

            @Override
            protected void start(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
                super.start(level, alchemist, gameTime);
                Mob piglinsCalled = (Mob)alchemist.getBrain().getMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
                piglinsCalled.getNavigation().moveTo((Entity)alchemist, 1.0);
            }

            @Override
            protected void tick(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
                super.tick(level, alchemist, gameTime);
                Mob piglinsCalled = (Mob)alchemist.getBrain().getMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
                piglinsCalled.getNavigation().moveTo((Entity)alchemist, 1.0);
            }
        }, (Object)1), (Object)Pair.of(new ThrowPotionAtTargetTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.FIRE_RESISTANCE), LivingEntity::isAlive, piglin -> piglin.isAlive() && piglin.isOnFire()), (Object)1), (Object)Pair.of(new ThrowPotionAtSelfTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.STRONG_REGENERATION), alchemist -> alchemist.isAlive() && alchemist.getHealth() < alchemist.getMaxHealth()), (Object)1), (Object)Pair.of(new ThrowPotionAtSelfTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.FIRE_RESISTANCE), alchemist -> alchemist.isAlive() && alchemist.isOnFire()), (Object)1), (Object)Pair.of(new ThrowPotionAtSelfTask(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.STRONG_HEALING), alchemist -> alchemist.isAlive() && alchemist.getHealth() < alchemist.getMaxHealth() && alchemist.beltInventory.noneMatch(stack -> CodeUtilities.potionContents(stack).potion().orElse(Potions.WATER) == Potions.STRONG_REGENERATION)), (Object)2)));
    }

    @Override
    public Optional<? extends LivingEntity> nearestValidAttackTarget(Piglin piglin) {
        Brain brain = piglin.getBrain();
        if (PiglinAlchemistAi.isNearZombified((Piglin)piglin)) {
            return Optional.empty();
        }
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)piglin, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional<LivingEntity> fallbackOptional = PiglinAlchemistAi.findNemesisTarget((Brain<? extends Piglin>)brain);
        if (fallbackOptional.isPresent()) {
            return fallbackOptional;
        }
        Optional optional2 = brain.getMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD);
        return optional2.isPresent() && Sensor.isEntityAttackable((LivingEntity)piglin, (LivingEntity)((LivingEntity)optional2.get())) ? optional2 : Optional.empty();
    }

    @Override
    public SoundEvent soundForActivity(PiglinAlchemist piglin, Activity activity) {
        if (activity == Activity.FIGHT) {
            return (SoundEvent)PPSounds.ALCHEMIST_ANGRY.get();
        }
        if (piglin.isConverting()) {
            return (SoundEvent)PPSounds.ALCHEMIST_RETREAT.get();
        }
        if (activity == Activity.AVOID && PiglinAlchemistAi.isNearAvoidTarget((Piglin)piglin)) {
            return (SoundEvent)PPSounds.ALCHEMIST_RETREAT.get();
        }
        if (activity == Activity.ADMIRE_ITEM) {
            return (SoundEvent)PPSounds.ALCHEMIST_ADMIRE.get();
        }
        if (activity == Activity.CELEBRATE) {
            return (SoundEvent)PPSounds.ALCHEMIST_CELEBRATE.get();
        }
        if (PiglinAlchemistAi.seesPlayerHoldingLovedItem((LivingEntity)piglin)) {
            return (SoundEvent)PPSounds.ALCHEMIST_JEALOUS.get();
        }
        return PiglinAlchemistAi.isNearRepellent((Piglin)piglin) ? (SoundEvent)PPSounds.ALCHEMIST_RETREAT.get() : (SoundEvent)PPSounds.ALCHEMIST_IDLE.get();
    }
}

