/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.blocks.PiglinSkullBlock;
import tallestred.piglinproliferation.common.entities.ai.PiglinTravelerAi;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.common.tags.EitherTag;
import tallestred.piglinproliferation.configuration.PPConfig;

public class PiglinTraveler
extends Piglin {
    protected static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(PiglinTraveler.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> KICK_TICKS = SynchedEntityData.defineId(PiglinTraveler.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> KICK_COOLDOWN = SynchedEntityData.defineId(PiglinTraveler.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int DEFAULT_EXPIRY_TIME = 24000;
    public Map<EitherTag.Location, Integer> alreadyLocatedObjects = new HashMap<EitherTag.Location, Integer>();
    public Map.Entry<EitherTag.Location, BlockPos> currentlyLocatedObject;

    public PiglinTraveler(EntityType<? extends PiglinTraveler> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean canReplaceCurrentItem(ItemStack pCandidate) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(pCandidate);
        ItemStack itemstack = this.getItemBySlot(equipmentslot);
        return this.canReplaceCurrentItem(pCandidate, itemstack);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource pSource, boolean pRecentlyHit) {
        PiglinSkullBlock.spawnSkullIfValidKill(pSource, (Entity)this, e -> (Item)PPItems.PIGLIN_TRAVELER_HEAD_ITEM.get());
        super.dropCustomDeathLoot(level, pSource, pRecentlyHit);
    }

    public void holdInOffHand(ItemStack pStack) {
        if (pStack.isPiglinCurrency()) {
            this.setItemSlot(EquipmentSlot.OFFHAND, pStack);
            this.setGuaranteedDrop(EquipmentSlot.OFFHAND);
        } else {
            this.setItemSlotAndDropWhenKilled(EquipmentSlot.OFFHAND, pStack);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        GlobalPos globalpos = GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)this.blockPosition());
        this.getBrain().setMemory(MemoryModuleType.HOME, (Object)globalpos);
        this.setItemSlot(EquipmentSlot.MAINHAND, (double)this.random.nextFloat() < (Double)PPConfig.COMMON.crossbowChanceTraveler.get() ? new ItemStack((ItemLike)Items.CROSSBOW) : new ItemStack((ItemLike)Items.GOLDEN_SWORD));
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void holdInMainHand(ItemStack pStack) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, pStack);
    }

    public boolean canHunt() {
        return super.canHunt();
    }

    protected Brain.Provider<PiglinTraveler> travelerBrainProvider() {
        ArrayList TRAVELER_MEMORY_TYPES = new ArrayList(Piglin.MEMORY_TYPES);
        return Brain.provider((Collection)ImmutableList.copyOf(TRAVELER_MEMORY_TYPES), (Collection)SENSOR_TYPES);
    }

    public void playBarteringAnimation() {
        this.swing(InteractionHand.MAIN_HAND, true);
        Vec3 vec3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
        vec3 = vec3.xRot(-this.getXRot() * ((float)Math.PI / 180));
        vec3 = vec3.yRot(-this.getYRot() * ((float)Math.PI / 180));
        double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
        Vec3 vec31 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.8, d0, 1.0 + ((double)this.random.nextFloat() - 0.5) * 0.4);
        vec31 = vec31.yRot(-this.yBodyRot * ((float)Math.PI / 180));
        vec31 = vec31.add(this.getX(), this.getEyeY() + 1.0, this.getZ());
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.GOLD_INGOT)), vec31.x, vec31.y, vec31.z, 1, vec3.x, vec3.y + 0.05, vec3.z, 0.0);
        } else {
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.GOLD_INGOT)), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
        }
    }

    public void tick() {
        if (this.getKickCoolDown() > 0) {
            this.setKickCoolDown(this.getKickCoolDown() - 1);
        }
        if (this.getKickTicks() > 0) {
            this.setKickTicks(this.getKickTicks() - 1);
        }
        super.tick();
    }

    protected void customServerAiStep() {
        this.timeInOverworld = this.isConverting() ? ++this.timeInOverworld : 0;
        if (this.timeInOverworld > 300 && EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.ZOMBIFIED_PIGLIN, timer -> {
            this.timeInOverworld = timer;
        })) {
            this.playConvertedSound();
            this.finishConversion((ServerLevel)this.level());
        }
        this.level().getProfiler().push("piglinBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        PiglinTravelerAi.INSTANCE.updateBrainActivity(this);
        this.alreadyLocatedObjects.replaceAll((key, value) -> value - 1);
        this.alreadyLocatedObjects.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
    }

    public boolean doHurtTarget(Entity mob) {
        return super.doHurtTarget(mob);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PiglinTravelerAi.INSTANCE.populateBrain(this, this.travelerBrainProvider().makeBrain(dynamic));
    }

    public boolean isBaby() {
        return false;
    }

    public static boolean checkTravelerSpawnRules(EntityType<PiglinTraveler> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return !levelAccessor.getBlockState(blockPos.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
        builder.define(KICK_COOLDOWN, (Object)0);
        builder.define(KICK_TICKS, (Object)0);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void sit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)PPSounds.TRAVELER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)PPSounds.TRAVELER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)PPSounds.TRAVELER_DEATH.get();
    }

    protected void playConvertedSound() {
        this.playSound((SoundEvent)PPSounds.TRAVELER_CONVERTED.get(), this.getSoundVolume(), this.getVoicePitch() * 0.35f);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.alreadyLocatedObjects = new HashMap<EitherTag.Location, Integer>();
        CompoundTag map = pCompound.getCompound("AlreadyLocatedObjects");
        for (String key : map.getAllKeys()) {
            this.alreadyLocatedObjects.put(EitherTag.Location.deserialise(key), map.getInt(key));
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        CompoundTag map = new CompoundTag();
        this.alreadyLocatedObjects.forEach((key, value) -> map.put(key.serialise(), (Tag)IntTag.valueOf((int)value)));
        pCompound.put("AlreadyLocatedObjects", (Tag)map);
    }

    public int getKickTicks() {
        return (Integer)this.entityData.get(KICK_TICKS);
    }

    public void setKickTicks(int kickTicks) {
        this.entityData.set(KICK_TICKS, (Object)kickTicks);
    }

    public int getKickCoolDown() {
        return (Integer)this.entityData.get(KICK_COOLDOWN);
    }

    public void setKickCoolDown(int kickCoolDown) {
        this.entityData.set(KICK_COOLDOWN, (Object)kickCoolDown);
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        return new Vec3(0.0, 0.55 * (double)this.getScale(), 0.0);
    }
}

