/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.blockentities.PPBlockEntities;
import tallestred.piglinproliferation.common.blockentities.PiglinSkullBlockEntity;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;

public class PiglinSkullBlock
extends SkullBlock {
    protected static final VoxelShape PIGLIN_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);

    public PiglinSkullBlock(SkullBlock.Type pType, BlockBehaviour.Properties pProperties) {
        super(pType, pProperties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return PIGLIN_SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PiglinSkullBlockEntity(pPos, pState);
    }

    public Types getType() {
        return (Types)super.getType();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? PiglinSkullBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)PPBlockEntities.PIGLIN_SKULL.get()), SkullBlockEntity::animation) : null;
    }

    public static void spawnSkullIfValidKill(DamageSource source, Entity killed, Function<Entity, Item> getItemIfValid) {
        Fireball fireBall;
        Entity spawnItem;
        Creeper creeper;
        Entity entity = source.getEntity();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).isPowered() && (spawnItem = getItemIfValid.apply(killed)) != null && creeper.canDropMobsSkull()) {
            killed.spawnAtLocation((ItemLike)spawnItem);
            creeper.increaseDroppedSkulls();
        }
        if ((spawnItem = source.getDirectEntity()) instanceof Fireball && (fireBall = (Fireball)spawnItem).getOwner() instanceof Ghast && (spawnItem = getItemIfValid.apply(killed)) != null) {
            killed.spawnAtLocation((ItemLike)spawnItem);
        }
    }

    public static enum Types implements SkullBlock.Type
    {
        PIGLIN_BRUTE("piglin_brute", () -> EntityType.PIGLIN_BRUTE, (Supplier<SoundEvent>)PPSounds.NOTE_BLOCK_IMITATE_PIGLIN_BRUTE),
        PIGLIN_ALCHEMIST("piglin_alchemist", () -> PPEntityTypes.PIGLIN_ALCHEMIST.get(), (Supplier<SoundEvent>)PPSounds.NOTE_BLOCK_IMITATE_PIGLIN_ALCHEMIST),
        ZOMBIFIED_PIGLIN("zombified_piglin", () -> EntityType.ZOMBIFIED_PIGLIN, (Supplier<SoundEvent>)PPSounds.NOTE_BLOCK_IMITATE_ZOMBIFIED_PIGLIN),
        PIGLIN_TRAVELER("piglin_traveler", () -> PPEntityTypes.PIGLIN_TRAVELER.get(), (Supplier<SoundEvent>)PPSounds.NOTE_BLOCK_IMITATE_PIGLIN_TRAVELER);

        private final String name;
        private final Supplier<EntityType<?>> entityType;
        private final Supplier<SoundEvent> noteBlockSound;

        private Types(String name, Supplier<EntityType<?>> entityType, Supplier<SoundEvent> noteBlockSound) {
            this.name = name;
            this.entityType = entityType;
            this.noteBlockSound = noteBlockSound;
            TYPES.put(name, this);
        }

        public String getSerializedName() {
            return this.name;
        }

        public EntityType<?> getEntityType() {
            return this.entityType.get();
        }

        public SoundEvent getSoundEvent() {
            return this.noteBlockSound.get();
        }
    }
}

