/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.blocks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tallestred.piglinproliferation.common.blocks.FireRingBlock;
import tallestred.piglinproliferation.common.blocks.PiglinSkullBlock;
import tallestred.piglinproliferation.common.blocks.PiglinWallSkullBlock;

public class PPBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"piglinproliferation");
    public static final Set<DeferredHolder<Block, ? extends AbstractSkullBlock>> PIGLIN_HEADS = new HashSet<DeferredHolder<Block, ? extends AbstractSkullBlock>>();
    public static final DeferredHolder<Block, PiglinSkullBlock> PIGLIN_BRUTE_HEAD = PPBlocks.registerHead("piglin_brute_head", PiglinSkullBlock.Types.PIGLIN_BRUTE);
    public static final DeferredHolder<Block, PiglinWallSkullBlock> PIGLIN_BRUTE_HEAD_WALL = PPBlocks.registerWallHead("piglin_brute_wall_head", PiglinSkullBlock.Types.PIGLIN_BRUTE);
    public static final DeferredHolder<Block, PiglinSkullBlock> ZOMBIFIED_PIGLIN_HEAD = PPBlocks.registerHead("zombified_piglin_head", PiglinSkullBlock.Types.ZOMBIFIED_PIGLIN);
    public static final DeferredHolder<Block, PiglinWallSkullBlock> ZOMBIFIED_PIGLIN_HEAD_WALL = PPBlocks.registerWallHead("zombified_piglin_wall_head", PiglinSkullBlock.Types.ZOMBIFIED_PIGLIN);
    public static final DeferredHolder<Block, PiglinSkullBlock> PIGLIN_ALCHEMIST_HEAD = PPBlocks.registerHead("piglin_alchemist_head", PiglinSkullBlock.Types.PIGLIN_ALCHEMIST);
    public static final DeferredHolder<Block, PiglinWallSkullBlock> PIGLIN_ALCHEMIST_HEAD_WALL = PPBlocks.registerWallHead("piglin_alchemist_wall_head", PiglinSkullBlock.Types.PIGLIN_ALCHEMIST);
    public static final DeferredHolder<Block, PiglinSkullBlock> PIGLIN_TRAVELER_HEAD = PPBlocks.registerHead("piglin_traveler_head", PiglinSkullBlock.Types.PIGLIN_TRAVELER);
    public static final DeferredHolder<Block, PiglinWallSkullBlock> PIGLIN_TRAVELER_HEAD_WALL = PPBlocks.registerWallHead("piglin_traveler_wall_head", PiglinSkullBlock.Types.PIGLIN_TRAVELER);
    public static final Set<DeferredHolder<Block, FireRingBlock>> FIRE_RINGS = new HashSet<DeferredHolder<Block, FireRingBlock>>();
    public static final DeferredHolder<Block, FireRingBlock> STONE_FIRE_RING = PPBlocks.registerFireRing("stone_fire_ring", false, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.STONE));
    public static final DeferredHolder<Block, FireRingBlock> STONE_SOUL_FIRE_RING = PPBlocks.registerFireRing("stone_soul_fire_ring", true, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.STONE));
    public static final DeferredHolder<Block, FireRingBlock> DEEPSLATE_FIRE_RING = PPBlocks.registerFireRing("deepslate_fire_ring", false, BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.DEEPSLATE));
    public static final DeferredHolder<Block, FireRingBlock> DEEPSLATE_SOUL_FIRE_RING = PPBlocks.registerFireRing("deepslate_soul_fire_ring", true, BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.DEEPSLATE));
    public static final DeferredHolder<Block, FireRingBlock> NETHERRACK_FIRE_RING = PPBlocks.registerFireRing("netherrack_fire_ring", false, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NETHERRACK));
    public static final DeferredHolder<Block, FireRingBlock> NETHERRACK_SOUL_FIRE_RING = PPBlocks.registerFireRing("netherrack_soul_fire_ring", true, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NETHERRACK));
    public static final DeferredHolder<Block, FireRingBlock> BLACKSTONE_FIRE_RING = PPBlocks.registerFireRing("blackstone_fire_ring", false, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.STONE));
    public static final DeferredHolder<Block, FireRingBlock> BLACKSTONE_SOUL_FIRE_RING = PPBlocks.registerFireRing("blackstone_soul_fire_ring", true, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.STONE));
    public static final DeferredHolder<Block, FireRingBlock> END_STONE_FIRE_RING = PPBlocks.registerFireRing("end_stone_fire_ring", false, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 9.0f));
    public static final DeferredHolder<Block, FireRingBlock> END_STONE_SOUL_FIRE_RING = PPBlocks.registerFireRing("end_stone_soul_fire_ring", true, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 9.0f));

    private static DeferredHolder<Block, FireRingBlock> registerFireRing(String name, boolean isSoulFire, BlockBehaviour.Properties properties) {
        DeferredHolder registeredBlock = BLOCKS.register(name, () -> new FireRingBlock(!isSoulFire, isSoulFire ? 2 : 1, isSoulFire ? 410 : 210, properties.lightLevel(Blocks.litBlockEmission((int)(isSoulFire ? 5 : 10))).noOcclusion().ignitedByLava()));
        FIRE_RINGS.add((DeferredHolder<Block, FireRingBlock>)registeredBlock);
        return registeredBlock;
    }

    private static DeferredHolder<Block, PiglinSkullBlock> registerHead(String name, PiglinSkullBlock.Types type) {
        DeferredHolder registeredBlock = BLOCKS.register(name, () -> new PiglinSkullBlock(type, BlockBehaviour.Properties.of().strength(1.0f).pushReaction(PushReaction.DESTROY)));
        PIGLIN_HEADS.add((DeferredHolder<Block, ? extends AbstractSkullBlock>)registeredBlock);
        return registeredBlock;
    }

    private static DeferredHolder<Block, PiglinWallSkullBlock> registerWallHead(String name, PiglinSkullBlock.Types type) {
        DeferredHolder registeredBlock = BLOCKS.register(name, () -> new PiglinWallSkullBlock(type, BlockBehaviour.Properties.of().strength(1.0f).pushReaction(PushReaction.DESTROY)));
        PIGLIN_HEADS.add((DeferredHolder<Block, ? extends AbstractSkullBlock>)registeredBlock);
        return registeredBlock;
    }
}

