/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.blockentities;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import tallestred.piglinproliferation.client.particles.PPParticles;
import tallestred.piglinproliferation.common.advancement.AddEffectToFireRing;
import tallestred.piglinproliferation.common.advancement.PPCriteriaTriggers;
import tallestred.piglinproliferation.common.blockentities.PPBlockEntities;
import tallestred.piglinproliferation.common.blocks.FireRingBlock;
import tallestred.piglinproliferation.configuration.PPConfig;

public class FireRingBlockEntity
extends CampfireBlockEntity {
    private final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    public boolean hasEffects = false;
    private final List<ParticleOptions> particles = new ArrayList<ParticleOptions>();
    public PotionContents potionContents = PotionContents.EMPTY;
    public int potionColor = 0xFFFFFF;
    private static final Logger LOGGER = LogUtils.getLogger();
    private int unsafeLightLevel = -1;

    public FireRingBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    private int getLightLevel() {
        if (this.unsafeLightLevel < 0) {
            BlockState state = this.getBlockState();
            BlockPos pos = this.getBlockPos();
            if (this.level != null) {
                this.unsafeLightLevel = state.getBlock().getLightEmission(state, (BlockGetter)this.level, pos);
            }
        }
        return this.unsafeLightLevel;
    }

    public boolean addEffects(@Nullable Player player, @Nullable InteractionHand hand, @Nullable ItemStack stack, PotionContents contents) {
        Iterable effectsToAdd = contents.getAllEffects();
        if (this.level != null && ((Boolean)this.getBlockState().getValue((Property)FireRingBlock.LIT)).booleanValue() && effectsToAdd.iterator().hasNext() && (this.level.isClientSide ? !this.hasEffects : this.effects.isEmpty())) {
            boolean hasInstantaneousEffects = false;
            for (MobEffectInstance effect : effectsToAdd) {
                if (!((MobEffect)effect.getEffect().value()).isInstantenous()) continue;
                hasInstantaneousEffects = true;
            }
            if (!hasInstantaneousEffects) {
                if (!this.level.isClientSide) {
                    if (player != null) {
                        ((AddEffectToFireRing)((Object)PPCriteriaTriggers.ADD_EFFECT_TO_FIRE_RING.get())).trigger((ServerPlayer)player);
                        if (stack != null) {
                            if (!player.getAbilities().instabuild) {
                                stack.shrink(1);
                                ItemStack result = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                                if (stack.isEmpty() && hand != null) {
                                    player.setItemInHand(hand, result);
                                }
                            }
                            this.level.playSound(null, this.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    this.potionContents = contents;
                    for (MobEffectInstance mobEffectInstance : effectsToAdd) {
                        int newDuration = mobEffectInstance.getDuration() >= (Integer)PPConfig.COMMON.maxRingDuration.get() ? ((Integer)PPConfig.COMMON.maxRingDuration.get()).intValue() : mobEffectInstance.getDuration();
                        int newAmplifier = mobEffectInstance.getAmplifier() >= (Integer)PPConfig.COMMON.maxEffect.get() ? ((Integer)PPConfig.COMMON.maxEffect.get()).intValue() : mobEffectInstance.getAmplifier();
                        MobEffectInstance modifiedEffect = new MobEffectInstance(mobEffectInstance.getEffect(), newDuration, newAmplifier);
                        this.effects.add(modifiedEffect);
                    }
                } else {
                    for (MobEffectInstance effect : effectsToAdd) {
                        if (!effect.isVisible()) continue;
                        this.particles.add(effect.getParticleOptions());
                    }
                    this.hasEffects = true;
                    this.potionColor = contents.getColor();
                }
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)FireRingBlock.BREWING, (Comparable)Boolean.valueOf(true)), 2);
                return true;
            }
        }
        return false;
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, FireRingBlockEntity blockEntity) {
        RandomSource random = level.random;
        if (!blockEntity.particles.isEmpty()) {
            level.addParticle((ParticleOptions)Util.getRandom(blockEntity.particles, (RandomSource)random), (double)pos.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + random.nextDouble() + random.nextDouble(), (double)pos.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 1.0, 1.25, 1.0);
        }
        if (!blockEntity.hasEffects) {
            CampfireBlockEntity.particleTick((Level)level, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)blockEntity);
        } else {
            RandomSource randomsource = level.random;
            if (randomsource.nextFloat() < 0.11f) {
                for (int i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                    ParticleType simpleparticletype = (Boolean)state.getValue((Property)CampfireBlock.SIGNAL_FIRE) != false ? (ParticleType)PPParticles.SIGNAL_COLORED_SMOKE.get() : (ParticleType)PPParticles.COLORED_SMOKE.get();
                    level.addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create((ParticleType)simpleparticletype, (int)blockEntity.potionColor), true, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            }
        }
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, FireRingBlockEntity blockEntity, int tempEffectTime) {
        boolean flag = false;
        FireRingBlockEntity.potionTick(level, pos, state, blockEntity, tempEffectTime);
        for (int i = 0; i < blockEntity.getItems().size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)blockEntity.getItems().get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            blockEntity.cookingProgress[n] = blockEntity.cookingProgress[n] + 1;
            if (blockEntity.cookingProgress[i] < blockEntity.cookingTime[i] || !(itemstack1 = blockEntity.quickCheck.getRecipeFor((RecipeInput)(singlerecipeinput = new SingleRecipeInput(itemstack)), level).map(p_344662_ -> ((CampfireCookingRecipe)p_344662_.value()).assemble(singlerecipeinput, (HolderLookup.Provider)level.registryAccess())).orElse(itemstack)).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemstack1);
            blockEntity.getItems().set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            FireRingBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, FireRingBlockEntity blockEntity) {
        if (!blockEntity.effects.isEmpty()) {
            blockEntity.effects.clear();
            blockEntity.syncToClient();
        }
        CampfireBlockEntity.cooldownTick((Level)level, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)blockEntity);
    }

    public static void potionTick(Level level, BlockPos pos, BlockState state, FireRingBlockEntity blockEntity, int tempEffectTime) {
        if (!blockEntity.effects.isEmpty()) {
            ArrayList<MobEffectInstance> toRemove = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance effectInstance : blockEntity.effects) {
                effectInstance.tickDownDuration();
                if (effectInstance.getDuration() > 0) continue;
                toRemove.add(effectInstance);
            }
            if (!toRemove.isEmpty() || blockEntity.particles.isEmpty()) {
                blockEntity.effects.removeAll(toRemove);
                blockEntity.syncToClient();
            }
            if (!blockEntity.effects.isEmpty()) {
                double radius = blockEntity.getLightLevel();
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, new AABB((double)x - radius, (double)y - radius, (double)z - radius, (double)x + radius, (double)y + radius, (double)z + radius))) {
                    blockEntity.effects.forEach(effect -> {
                        if (((List)PPConfig.COMMON.effectsThatShouldNotBeAppliedContinously.get()).contains(effect.getEffect().getRegisteredName()) && !entity.hasEffect(effect.getEffect())) {
                            entity.addEffect(new MobEffectInstance(effect.getEffect(), tempEffectTime, effect.getAmplifier(), true, effect.isVisible()));
                        } else if (!((List)PPConfig.COMMON.effectsThatShouldNotBeAppliedContinously.get()).contains(effect.getEffect().getRegisteredName())) {
                            entity.addEffect(new MobEffectInstance(effect.getEffect(), tempEffectTime, effect.getAmplifier(), true, effect.isVisible()));
                        }
                    });
                }
            }
            blockEntity.setChanged();
        }
    }

    public void syncToClient() {
        this.hasEffects = !this.effects.isEmpty();
        this.particles.clear();
        this.potionColor = this.potionContents.getColor();
        for (MobEffectInstance effect : this.effects) {
            if (!effect.isVisible()) continue;
            this.particles.add(effect.getParticleOptions());
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)FireRingBlock.BREWING, (Comparable)Boolean.valueOf(this.hasEffects)), 2);
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        this.setChanged();
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)PPBlockEntities.FIRE_RING.get();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.effects.clear();
        ListTag effectsTag = tag.getList("Effects", 10);
        for (Tag effectTag : effectsTag) {
            if (!(effectTag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)effectTag;
            this.effects.add(MobEffectInstance.load((CompoundTag)compoundTag));
        }
        if (tag.contains("potion_contents")) {
            RegistryOps registryops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            PotionContents.CODEC.parse((DynamicOps)registryops, (Object)tag.get("potion_contents")).resultOrPartial(p_340707_ -> LOGGER.warn("Failed to parse area effect cloud potions: '{}'", p_340707_)).ifPresent(this::setPotionContents);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag effectsTag = new ListTag();
        for (MobEffectInstance effectInstance : this.effects) {
            effectsTag.add((Object)effectInstance.save());
        }
        tag.put("Effects", (Tag)effectsTag);
        if (!this.potionContents.equals((Object)PotionContents.EMPTY)) {
            RegistryOps registryops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            Tag potionTag = (Tag)PotionContents.CODEC.encodeStart((DynamicOps)registryops, (Object)this.potionContents).getOrThrow();
            tag.put("potion_contents", potionTag);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        ListTag particlesTag = new ListTag();
        for (ParticleOptions options : this.particles) {
            ParticleTypes.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)options).result().ifPresent(arg_0 -> particlesTag.add(arg_0));
        }
        tag.put("Particles", (Tag)particlesTag);
        tag.putInt("Color", this.potionColor);
        tag.putBoolean("HasEffects", this.hasEffects);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        if (tag.contains("Particles", 9)) {
            ListTag particlesTag = tag.getList("Particles", 10);
            this.particles.clear();
            particlesTag.forEach(pTag -> ParticleTypes.CODEC.parse((DynamicOps)NbtOps.INSTANCE, pTag).result().ifPresent(this.particles::add));
        }
        if (tag.contains("HasEffects")) {
            this.hasEffects = tag.getBoolean("HasEffects");
        }
        if (tag.contains("Color")) {
            this.potionColor = tag.getInt("Color");
        }
    }

    public void setPotionContents(PotionContents potionContents) {
        this.potionContents = potionContents;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        super.onDataPacket(net, packet, provider);
        this.handleUpdateTag(packet.getTag(), provider);
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }
}

