/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.attribute;

import java.util.Random;
import java.util.random.RandomGenerator;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import tallestred.piglinproliferation.common.attribute.AbstractAttributeModifierHolder;
import tallestred.piglinproliferation.util.CodeUtilities;

public class RangedRandomAttributeModifierHolder
extends AbstractAttributeModifierHolder {
    public final double defaultMinAmount;
    public final double defaultMaxAmount;
    public final AttributeModifier.Operation defaultOperation;
    protected final Instance defaultInstance;

    public RangedRandomAttributeModifierHolder(Holder<Attribute> attribute, String name, double defaultMinAmount, double defaultMaxAmount, AttributeModifier.Operation defaultOperation) {
        super(attribute, name);
        this.defaultMinAmount = defaultMinAmount;
        this.defaultMaxAmount = defaultMaxAmount;
        this.defaultOperation = defaultOperation;
        this.defaultInstance = new Instance(defaultMinAmount, defaultMaxAmount, defaultOperation);
    }

    @Override
    public Instance get() {
        return this.defaultInstance;
    }

    @Override
    public Instance getWithMultiplier(double multiplier) {
        return this.getWithMultipliers(multiplier, multiplier);
    }

    public Instance getWithMultipliers(double minMultiplier, double maxMultiplier) {
        return new Instance(this.defaultMinAmount * minMultiplier, this.defaultMaxAmount * maxMultiplier, this.defaultOperation);
    }

    @Override
    public Instance getWithSummand(double summand) {
        return this.getWithSummands(summand, summand);
    }

    public Instance getWithSummands(double minSummand, double maxSummand) {
        return new Instance(this.defaultMinAmount + minSummand, this.defaultMaxAmount + maxSummand, this.defaultOperation);
    }

    public Instance getWithNewAmounts(double newMinAmount, double newMaxAmount) {
        return new Instance(newMinAmount, newMaxAmount, this.defaultOperation);
    }

    public Instance getWithNewAmountAndOperation(double newMinAmount, double newMaxAmount, AttributeModifier.Operation operation) {
        return new Instance(newMinAmount, newMaxAmount, operation);
    }

    public class Instance
    extends AbstractAttributeModifierHolder.Instance {
        public final double minAmount;
        public final double maxAmount;
        public final AttributeModifier.Operation operation;
        protected RandomGenerator random;

        protected Instance(double minAmount, double maxAmount, AttributeModifier.Operation operation) {
            super(RangedRandomAttributeModifierHolder.this);
            this.random = new Random();
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
            this.operation = operation;
        }

        public AttributeModifier modifier() {
            return this.modifier(this.randomAmount());
        }

        public AttributeModifier modifier(double amount) {
            return new AttributeModifier(RangedRandomAttributeModifierHolder.this.resourceLocation, CodeUtilities.capToRange(amount, this.minAmount, this.maxAmount), this.operation);
        }

        @Override
        public void addTransientModifier(LivingEntity entity) {
            this.addTransientInternal(this.modifier(), entity);
        }

        @Override
        public void addPermanentModifier(LivingEntity entity) {
            this.addPermanentInternal(this.modifier(), entity);
        }

        @Override
        public MutableComponent translatable() {
            return this.translatableInternal(this.maxAmount, this.operation, false, -1.0);
        }

        @Override
        public MutableComponent translatable(double baseAmount) {
            return this.translatableInternal(this.maxAmount, this.operation, true, baseAmount);
        }

        @Override
        protected MutableComponent translatableInternal(double maxAmount, AttributeModifier.Operation operation, boolean displaysBase, double baseValue) {
            MutableComponent result = super.translatableInternal(maxAmount, operation, displaysBase, baseValue);
            ComponentContents componentContents = result.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)componentContents;
                String newKey = contents.getKey().replace("modifier", "piglinproliferation.ranged_modifier");
                Object[] oldArgs = contents.getArgs();
                Object[] newArgs = new Object[contents.getArgs().length + 1];
                newArgs[0] = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.formattedAmount(this.minAmount, operation, displaysBase, baseValue));
                System.arraycopy(oldArgs, 0, newArgs, 1, oldArgs.length);
                result = Component.translatable((String)newKey, (Object[])newArgs).withStyle(result.getStyle());
            }
            return result;
        }

        public double randomAmount() {
            return this.random().nextDouble(this.minAmount, this.maxAmount);
        }

        public int randomIntAmount() {
            return this.random().nextInt(Math.round((float)this.minAmount), Math.round((float)this.maxAmount) + 1);
        }

        protected RandomGenerator random() {
            return this.random;
        }
    }
}

