/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.attribute;

import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public abstract class AbstractAttributeModifierHolder {
    public final Holder<Attribute> attribute;
    public final ResourceLocation resourceLocation;
    public final String name;

    public AbstractAttributeModifierHolder(Holder<Attribute> attribute, String name) {
        this.attribute = attribute;
        this.name = name;
        this.resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"piglinproliferation", (String)name);
    }

    public abstract Instance get();

    public abstract Instance getWithMultiplier(double var1);

    public abstract Instance getWithSummand(double var1);

    public boolean hasModifier(LivingEntity entity) {
        return entity.getAttributes().hasModifier(this.attribute, this.resourceLocation);
    }

    public void removeModifier(LivingEntity entity) {
        AttributeInstance instance = entity.getAttribute(this.attribute);
        if (instance != null) {
            instance.removeModifier(this.resourceLocation);
        }
    }

    public abstract class Instance {
        public void resetTransientModifier(LivingEntity entity) {
            AbstractAttributeModifierHolder.this.removeModifier(entity);
            this.addTransientModifier(entity);
        }

        public void resetPermanentModifier(LivingEntity entity) {
            AbstractAttributeModifierHolder.this.removeModifier(entity);
            this.addPermanentModifier(entity);
        }

        public abstract void addTransientModifier(LivingEntity var1);

        public abstract void addPermanentModifier(LivingEntity var1);

        protected void addTransientInternal(AttributeModifier modifier, LivingEntity entity) {
            AttributeInstance instance = entity.getAttribute(AbstractAttributeModifierHolder.this.attribute);
            if (instance != null) {
                instance.addTransientModifier(modifier);
            }
        }

        protected void addPermanentInternal(AttributeModifier modifier, LivingEntity entity) {
            AttributeInstance instance = entity.getAttribute(AbstractAttributeModifierHolder.this.attribute);
            if (instance != null) {
                instance.addPermanentModifier(modifier);
            }
        }

        public abstract MutableComponent translatable();

        public abstract MutableComponent translatable(double var1);

        protected MutableComponent translatableInternal(double amount, AttributeModifier.Operation operation, boolean displaysBase, double base) {
            amount = this.formattedAmount(amount, operation, displaysBase, base);
            String key = "attribute.modifier.equals.";
            ChatFormatting style = ChatFormatting.DARK_GREEN;
            if (!displaysBase) {
                if (amount > 0.0) {
                    key = "attribute.modifier.plus.";
                    style = ChatFormatting.BLUE;
                }
                if (amount < 0.0) {
                    amount *= -1.0;
                    key = "attribute.modifier.take.";
                    style = ChatFormatting.RED;
                }
            }
            return Component.translatable((String)(key + operation.id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount), Component.translatable((String)((Attribute)AbstractAttributeModifierHolder.this.attribute.value()).getDescriptionId())}).withStyle(style);
        }

        protected double formattedAmount(double amount, AttributeModifier.Operation operation, boolean displaysBase, double base) {
            if (displaysBase) {
                amount += base;
            }
            switch (operation) {
                case ADD_VALUE: {
                    amount *= AbstractAttributeModifierHolder.this.attribute.equals((Object)Attributes.KNOCKBACK_RESISTANCE) ? 10.0 : 1.0;
                    break;
                }
                case ADD_MULTIPLIED_BASE: 
                case ADD_MULTIPLIED_TOTAL: {
                    amount *= 100.0;
                }
            }
            return amount;
        }
    }
}

