/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client.renderers.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import tallestred.piglinproliferation.client.models.PiglinAlchemistModel;
import tallestred.piglinproliferation.client.renderers.PPRenderSetupEvents;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class BeltRenderLayer<T extends PiglinAlchemist, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;
    private final PiglinAlchemistModel<T> layerModel = new PiglinAlchemistModel(Minecraft.getInstance().getEntityModels().bakeLayer(PPRenderSetupEvents.PIGLIN_ALCHEMIST_BELT_SLOTS));

    public BeltRenderLayer(RenderLayerParent p_117183_, ItemInHandRenderer itemInHandRenderer) {
        super(p_117183_);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T alchemist, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
            ItemDisplayContext transformType;
            ItemStack itemstack = ((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
            if (!itemstack.isEmpty()) {
                pMatrixStack.pushPose();
                if (this.getParentModel().young) {
                    pMatrixStack.translate(0.0, 0.75, 0.0);
                    pMatrixStack.scale(0.5f, 0.5f, 0.5f);
                }
                this.renderBeltItems((LivingEntity)alchemist, itemstack, ItemDisplayContext.GROUND, pMatrixStack, pBuffer, pAgeInTicks, pPackedLight, slot);
                pMatrixStack.popPose();
            }
            HumanoidArm arm = alchemist.isLeftHanded() ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
            ItemDisplayContext itemDisplayContext = transformType = alchemist.isLeftHanded() ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            if (!((PiglinAlchemist)((Object)alchemist)).isGonnaThrowPotion()) continue;
            pMatrixStack.pushPose();
            if (this.getParentModel().young) {
                pMatrixStack.translate(0.0, 0.75, 0.0);
                pMatrixStack.scale(0.5f, 0.5f, 0.5f);
            }
            this.renderArmWithItem((LivingEntity)alchemist, ((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand(), transformType, arm, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
        }
        BeltRenderLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.layerModel, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"piglinproliferation", (String)"textures/entity/piglin/alchemist/belt.png"), (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, alchemist, (float)pLimbSwing, (float)pLimbSwingAmount, (float)pAgeInTicks, (float)pNetHeadYaw, (float)pHeadPitch, (float)pPartialTicks, (int)-1);
    }

    protected void renderBeltItems(LivingEntity entity, ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource source, float ageInTicks, int light, int inventorySlot) {
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            ((PiglinModel)this.getParentModel()).body.translateAndRotate(poseStack);
            poseStack.scale(0.8f, 0.8f, 0.8f);
            if (inventorySlot > 2 || inventorySlot != 5) {
                double d = -0.24 + (double)inventorySlot * 0.44;
                double inflation = entity.hasItemInSlot(EquipmentSlot.LEGS) && !entity.hasItemInSlot(EquipmentSlot.CHEST) ? 0.215 : (entity.hasItemInSlot(EquipmentSlot.CHEST) ? 0.245 : 0.165);
                poseStack.translate(inventorySlot > 2 && inventorySlot != 5 ? -d + 1.25 : d, 0.8, inventorySlot > 2 && inventorySlot != 5 ? inflation : -inflation);
            }
            if (inventorySlot == 2 || inventorySlot == 5) {
                double secondSlotInflation;
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                double d = entity.hasItemInSlot(EquipmentSlot.LEGS) && !entity.hasItemInSlot(EquipmentSlot.CHEST) ? -0.29 : (secondSlotInflation = entity.hasItemInSlot(EquipmentSlot.CHEST) ? -0.265 : -0.325);
                double fifthSlotInflation = entity.hasItemInSlot(EquipmentSlot.LEGS) && !entity.hasItemInSlot(EquipmentSlot.CHEST) ? -2.31 : (entity.hasItemInSlot(EquipmentSlot.CHEST) ? -2.335 : -2.275);
                poseStack.translate(-0.2, 0.4, inventorySlot == 2 ? secondSlotInflation : fifthSlotInflation);
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, entity.level(), entity, light);
            Minecraft.getInstance().getItemRenderer().render(stack, transformType, false, poseStack, source, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), model);
            poseStack.popPose();
        }
    }

    protected void renderArmWithItem(LivingEntity p_117185_, ItemStack p_117186_, ItemDisplayContext p_117187_, HumanoidArm p_117188_, PoseStack p_117189_, MultiBufferSource p_117190_, int p_117191_) {
        if (!p_117186_.isEmpty()) {
            p_117189_.pushPose();
            ((ArmedModel)this.getParentModel()).translateToHand(p_117188_, p_117189_);
            p_117189_.mulPose(Axis.XP.rotationDegrees(-90.0f));
            p_117189_.mulPose(Axis.YP.rotationDegrees(180.0f));
            boolean flag = p_117188_ == HumanoidArm.LEFT;
            p_117189_.translate((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            this.itemInHandRenderer.renderItem(p_117185_, p_117186_, p_117187_, flag, p_117189_, p_117190_, p_117191_);
            p_117189_.popPose();
        }
    }
}

