/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import tallestred.piglinproliferation.PiglinProliferation;
import tallestred.piglinproliferation.capablities.PPDataAttachments;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.blockentities.PPBlockEntities;
import tallestred.piglinproliferation.common.blocks.PiglinSkullBlock;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;
import tallestred.piglinproliferation.common.entities.ZiglinVariantWeight;
import tallestred.piglinproliferation.common.entities.ZombifiedPiglinVariant;
import tallestred.piglinproliferation.common.entities.ai.goals.DumbBowAttackGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.DumbCrossbowAttackGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinCallForHelpGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinSwimInLavaGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.UseBucklerGoal;
import tallestred.piglinproliferation.common.entities.spawns.TravelerSpawner;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.common.loot.CompassCanFindLocationCondition;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.networking.CriticalCapabilityPacket;
import tallestred.piglinproliferation.networking.ZiglinCapabilitySyncPacket;
import tallestred.piglinproliferation.util.CodeUtilities;

@EventBusSubscriber(modid="piglinproliferation")
public class PPEvents {
    private static List<ZiglinVariantWeight> ziglinVariants = List.of();

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(event.getEntity())) > 0) {
            event.getEntity().setDeltaMovement(event.getEntity().getDeltaMovement().x(), 0.0, event.getEntity().getDeltaMovement().z());
        }
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ZombifiedPiglin) {
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getEntity().level().isClientSide) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)ziglin, (CustomPacketPayload)new ZiglinCapabilitySyncPacket(ziglin.getId(), (String)ziglin.getData(PPDataAttachments.TRANSFORMATION_TRACKER.get())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            ziglin.goalSelector.addGoal(2, new DumbBowAttackGoal<ZombifiedPiglin>(ziglin, 0.5, 20, 15.0f));
            ziglin.goalSelector.addGoal(2, new DumbCrossbowAttackGoal<ZombifiedPiglin>(ziglin, 1.0, 8.0f));
        }
        if ((entity = event.getEntity()) instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            piglin.goalSelector.addGoal(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.isOnFire() && !piglin1.hasEffect(MobEffects.FIRE_RESISTANCE), alchemist -> alchemist.getItemShownOnOffhand() != null && CodeUtilities.potionContents(alchemist.getItemShownOnOffhand()).potion().orElse(Potions.WATER) == Potions.FIRE_RESISTANCE));
            piglin.goalSelector.addGoal(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.getHealth() < piglin1.getMaxHealth() && !piglin1.hasEffect(MobEffects.REGENERATION), alchemist -> alchemist.getItemShownOnOffhand() != null && CodeUtilities.potionContents(alchemist.getItemShownOnOffhand()).potion().orElse(Potions.WATER) == Potions.STRONG_REGENERATION));
            piglin.goalSelector.addGoal(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.getHealth() < piglin1.getMaxHealth() && !piglin1.hasEffect(MobEffects.HEAL), alchemist -> alchemist.getItemShownOnOffhand() != null && CodeUtilities.potionContents(alchemist.getItemShownOnOffhand()).potion().orElse(Potions.WATER) == Potions.STRONG_HEALING));
            piglin.goalSelector.addGoal(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.getHealth() < piglin1.getMaxHealth() / 2.0f && piglin1.getTarget() != null && !piglin1.hasEffect(MobEffects.DAMAGE_BOOST), alchemist -> alchemist.getItemShownOnOffhand() != null && CodeUtilities.potionContents(alchemist.getItemShownOnOffhand()).potion().orElse(Potions.WATER) == Potions.STRONG_STRENGTH));
            piglin.goalSelector.addGoal(1, (Goal)new PiglinSwimInLavaGoal((Mob)piglin));
        }
        if ((entity = event.getEntity()) instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            if (((List)PPConfig.COMMON.mobsThatCanAlsoUseBuckler.get()).contains(mob.getEncodeId())) {
                mob.goalSelector.addGoal(2, new UseBucklerGoal<PathfinderMob>(mob));
            }
        }
        if ((entity = event.getEntity()) instanceof AreaEffectCloud) {
            AreaEffectCloud lingeringCloud = (AreaEffectCloud)entity;
            int centreX = (int)lingeringCloud.getX();
            int centreY = (int)lingeringCloud.getY();
            int centreZ = (int)lingeringCloud.getZ();
            int radius = (int)lingeringCloud.getRadius();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(centreX, centreY, centreZ);
            for (int x = centreX - radius; x < centreX + radius; ++x) {
                for (int z = centreZ - radius; z < centreZ + radius; ++z) {
                    mutable.setX(x);
                    mutable.setZ(z);
                    if (lingeringCloud.potionContents.hasEffects()) continue;
                    try {
                        event.getLevel().getBlockEntity((BlockPos)mutable, (BlockEntityType)PPBlockEntities.FIRE_RING.get()).ifPresent(fireRing -> fireRing.addEffects(CodeUtilities.castOrNull(lingeringCloud.getOwner(), Player.class), null, null, lingeringCloud.potionContents));
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException execption) {
                        lingeringCloud.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ZombifiedPiglin) {
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getTarget().level().isClientSide) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)ziglin, (CustomPacketPayload)new ZiglinCapabilitySyncPacket(ziglin.getId(), (String)ziglin.getData(PPDataAttachments.TRANSFORMATION_TRACKER.get())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            Entity entity2;
            boolean criticalAfterCharge;
            LivingEntity entity3 = (LivingEntity)entity;
            ItemStack bucklerItemStack = PPItems.checkEachHandForBuckler(entity3);
            boolean bucklerReadyToCharge = BucklerItem.isReady(bucklerItemStack);
            int bucklerChargeTicks = BucklerItem.getChargeTicks(bucklerItemStack);
            if (bucklerReadyToCharge) {
                BucklerItem.setChargeTicks(bucklerItemStack, bucklerChargeTicks - 1);
                if (bucklerChargeTicks > 0) {
                    BucklerItem.moveFowards(entity3);
                    BucklerItem.spawnRunningEffectsWhileCharging(entity3);
                    if (entity3.horizontalCollision && PPEnchantments.hasBucklerEnchantsOnHands(entity3, PPEnchantments.TURNING)) {
                        entity3.setDeltaMovement(entity3.getDeltaMovement().x, (Double)PPConfig.COMMON.turningBucklerLaunchStrength.get() * (double)PPEnchantments.getBucklerEnchantsOnHands(PPEnchantments.TURNING, entity3), entity3.getDeltaMovement().z);
                    }
                    if (!entity3.level().isClientSide()) {
                        BucklerItem.bucklerBash(entity3);
                    }
                }
            }
            if (bucklerChargeTicks <= 0 && bucklerReadyToCharge || BucklerItem.CHARGE_SPEED_BOOST.hasModifier(entity3) && (!(bucklerItemStack.getItem() instanceof BucklerItem) || !bucklerReadyToCharge)) {
                entity3.setDeltaMovement(Vec3.ZERO);
                BucklerItem.TURNING_SPEED_REDUCTION.removeModifier(entity3);
                BucklerItem.CHARGE_SPEED_BOOST.removeModifier(entity3);
                BucklerItem.CHARGE_JUMP_PREVENTION.removeModifier(entity3);
                BucklerItem.INCREASED_KNOCKBACK_RESISTANCE.removeModifier(entity3);
                BucklerItem.setChargeTicks(bucklerItemStack, 0);
                BucklerItem.setReady(bucklerItemStack, false);
                entity3.stopUsingItem();
                if (entity3 instanceof Player) {
                    Player player = (Player)entity3;
                    for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                        if (!(player.getInventory().getItem(slot).getItem() instanceof BucklerItem)) continue;
                        BucklerItem.setChargeTicks(player.getInventory().getItem(slot), 0);
                        BucklerItem.setReady(player.getInventory().getItem(slot), false);
                    }
                }
            }
            if (criticalAfterCharge = ((Boolean)entity3.getData(PPDataAttachments.CRITICAL.get())).booleanValue()) {
                if (entity3.swingTime > 0) {
                    entity3.level().playSound(null, entity3.getX(), entity3.getY(), entity3.getZ(), (SoundEvent)PPSounds.CRITICAL_DEACTIVATE.get(), entity3.getSoundSource(), 1.0f, 0.8f + entity3.getRandom().nextFloat() * 0.4f);
                    entity3.setData(PPDataAttachments.CRITICAL.get(), (Object)false);
                }
                if (!entity3.level().isClientSide) {
                    ((ServerLevel)entity3.level()).sendParticles((ParticleOptions)ParticleTypes.CRIT, entity3.getRandomX(2.0), entity3.getRandomY() + 1.0, entity3.getRandomZ(2.0), 1, 0.0, 0.0, 0.0, (double)0.15f);
                }
            }
            if ((entity2 = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CriticalCapabilityPacket(player.getId(), criticalAfterCharge), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Added event) {
        if (event.getEffectInstance() != null) {
            Holder mobEffect = event.getEffectInstance().getEffect();
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof AbstractPiglin) {
                AbstractPiglin piglin = (AbstractPiglin)livingEntity;
                if (mobEffect == MobEffects.FIRE_RESISTANCE) {
                    piglin.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
                    piglin.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
                    piglin.setPathfindingMalus(PathType.LAVA, 0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        Holder mobEffect = event.getEffectInstance().getEffect();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.FIRE_RESISTANCE) {
                piglin.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
                piglin.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
                piglin.setPathfindingMalus(PathType.LAVA, -1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEntity(LivingDamageEvent.Pre event) {
        Entity entity = event.getContainer().getSource().getDirectEntity();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            if (((Boolean)PPConfig.COMMON.healingArrowDamage.get()).booleanValue()) {
                for (MobEffectInstance mobeffectinstance : arrow.getPotionContents().getAllEffects()) {
                    if (mobeffectinstance.getEffect() != MobEffects.REGENERATION && mobeffectinstance.getEffect() != MobEffects.HEAL) continue;
                    if (event.getEntity() instanceof Mob && event.getEntity().isInvertedHealAndHarm()) {
                        return;
                    }
                    event.getContainer().setNewDamage(0.0f);
                    arrow.level().playSound(null, arrow.blockPosition(), (SoundEvent)PPSounds.REGEN_HEALING_ARROW_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    event.getEntity().setDeltaMovement(event.getEntity().getDeltaMovement().multiply(-1.0, -1.0, -1.0));
                    event.getEntity().invulnerableTime = 0;
                    event.getEntity().hurtTime = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void attackEntity(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            for (Entity rider : mob.getPassengers()) {
                if (!mob.isInvertedHealAndHarm() || !(event.getSource().getEntity() instanceof AbstractPiglin) || !(rider instanceof AbstractPiglin)) continue;
                AbstractPiglin piglin = (AbstractPiglin)rider;
                if (!event.getSource().is(DamageTypes.MAGIC)) continue;
                if (event.getEntity().level().isClientSide) {
                    return;
                }
                piglin.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void targetMob(LivingChangeTargetEvent event) {
        if (event.getEntity() instanceof AbstractPiglin && event.getOriginalAboutToBeSetTarget() instanceof AbstractPiglin) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof ZombifiedPiglin && event.getOriginalAboutToBeSetTarget() instanceof ZombifiedPiglin) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (((Boolean)player.getData(PPDataAttachments.CRITICAL.get())).booleanValue()) {
            event.setCriticalHit(true);
            event.setDamageMultiplier(1.5f);
            Player entity = event.getEntity();
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, entity.getSoundSource(), 1.0f, 1.0f);
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)PPSounds.CRITICAL_APPLY.get(), entity.getSoundSource(), 1.0f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
            player.setData(PPDataAttachments.CRITICAL.get(), (Object)false);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(LivingShieldBlockEvent event) {
        if (event.getEntity().getUseItem().getItem() instanceof BucklerItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void finalizeSpawn(FinalizeSpawnEvent event) {
        Object traveler;
        MobSpawnType spawnType = event.getSpawnType();
        RandomSource random = event.getLevel().getRandom();
        Mob mob = event.getEntity();
        if (mob instanceof Strider) {
            Strider strider = (Strider)mob;
            if (random.nextInt(60) == 0 && !strider.isBaby()) {
                event.setCanceled(true);
                traveler = (PiglinTraveler)((EntityType)PPEntityTypes.PIGLIN_TRAVELER.get()).create(strider.level());
                if (traveler != null) {
                    traveler.copyPosition((Entity)strider);
                    traveler.startRiding((Entity)strider);
                    strider.equipSaddle(new ItemStack((ItemLike)Items.SADDLE), null);
                    traveler.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WARPED_FUNGUS_ON_A_STICK));
                }
            }
        }
        if ((traveler = event.getEntity()) instanceof PiglinBrute) {
            PiglinBrute piglinBrute = (PiglinBrute)traveler;
            if (random.nextFloat() < ((Double)PPConfig.COMMON.BruteBuckler.get()).floatValue()) {
                piglinBrute.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)PPItems.BUCKLER.get()));
                ItemStack itemstack = piglinBrute.getOffhandItem();
                if (itemstack.getItem() instanceof BucklerItem) {
                    if (random.nextInt(300) == 0) {
                        itemstack.enchant(PPEnchantments.getEnchant(PPEnchantments.TURNING, piglinBrute.registryAccess()), 5);
                    }
                    if (random.nextInt(500) == 0) {
                        itemstack.enchant(PPEnchantments.getEnchant(PPEnchantments.BANG, piglinBrute.registryAccess()), 1);
                    }
                    piglinBrute.setItemSlot(EquipmentSlot.OFFHAND, itemstack);
                }
            }
        }
        if (event.getEntity().getType() == EntityType.ZOMBIFIED_PIGLIN) {
            ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)event.getEntity();
            if (spawnType != MobSpawnType.CONVERSION) {
                if (random.nextFloat() < ((Double)PPConfig.COMMON.zombifiedPiglinDefaultChance.get()).floatValue()) {
                    zombifiedPiglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)"piglin");
                }
                float bruteChance = ((Double)PPConfig.COMMON.zombifiedBruteChance.get()).floatValue();
                if (((String)zombifiedPiglin.getData(PPDataAttachments.TRANSFORMATION_TRACKER.get())).equalsIgnoreCase("piglin")) {
                    if (random.nextFloat() < bruteChance) {
                        event.setCanceled(true);
                        zombifiedPiglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)"piglin_brute");
                        zombifiedPiglin.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_AXE));
                        zombifiedPiglin.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)PPItems.BUCKLER.get()));
                    } else if (random.nextFloat() < ((Double)PPConfig.COMMON.zombifiedAlchemistChance.get()).floatValue()) {
                        event.setCanceled(true);
                        zombifiedPiglin.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
                        zombifiedPiglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)"piglin_alchemist");
                    } else {
                        if (random.nextFloat() < ((Double)PPConfig.COMMON.zombifiedTravelerChance.get()).floatValue()) {
                            zombifiedPiglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)"piglin_traveler");
                        }
                        if (random.nextFloat() < ((Double)PPConfig.COMMON.crossbowChance.get()).floatValue()) {
                            event.setCanceled(true);
                            zombifiedPiglin.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
                        }
                    }
                    if (!ziglinVariants.isEmpty()) {
                        EntityType<?> variantType = ((ZiglinVariantWeight)WeightedRandom.getRandomItem((RandomSource)random, ziglinVariants).orElseThrow()).type();
                        Item item = ((ZiglinVariantWeight)WeightedRandom.getRandomItem((RandomSource)random, ziglinVariants).orElseThrow()).itemId();
                        ResourceLocation resourcelocation = BuiltInRegistries.ENTITY_TYPE.getKey(variantType);
                        zombifiedPiglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)resourcelocation.getPath());
                        zombifiedPiglin.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item));
                    }
                }
                if (spawnType == MobSpawnType.JOCKEY) {
                    event.setCanceled(true);
                    zombifiedPiglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)"piglin_traveler");
                    zombifiedPiglin.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WARPED_FUNGUS_ON_A_STICK));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDataMapsUpdated(DataMapsUpdatedEvent event) {
        event.ifRegistry(Registries.ENTITY_TYPE, registry -> {
            ziglinVariants = registry.getDataMap(PiglinProliferation.ZOMBIFIED_PIGLIN_VARIANT_DATA_MAP).entrySet().stream().map(entry -> {
                EntityType type = Objects.requireNonNull((EntityType)registry.get((ResourceKey)entry.getKey()), "Nonexistent entity " + String.valueOf(entry.getKey()) + " in modded ziglin variant datamap!");
                return new ZiglinVariantWeight(type, ((ZombifiedPiglinVariant)entry.getValue()).weight(), ((ZombifiedPiglinVariant)entry.getValue()).itemID());
            }).toList();
        });
    }

    @SubscribeEvent
    public static void visionPercent(LivingEvent.LivingVisibilityEvent event) {
        if (event.getLookingEntity() != null) {
            ItemStack itemstack = event.getEntity().getItemBySlot(EquipmentSlot.HEAD);
            if (event.getLookingEntity() instanceof AbstractPiglin && PPItems.PIGLIN_HEADS.keySet().stream().anyMatch(h -> h.get() == itemstack.getItem())) {
                event.modifyVisibility(0.5);
            }
        }
    }

    @SubscribeEvent
    public static void onConvert(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (event.getOutcome().getType() == EntityType.ZOMBIFIED_PIGLIN) {
                ResourceLocation location;
                if (piglin.level().isClientSide) {
                    return;
                }
                ZombifiedPiglin ziglin = (ZombifiedPiglin)event.getOutcome();
                Optional registryOptional = piglin.level().registryAccess().registry(Registries.ENTITY_TYPE);
                if (registryOptional.isPresent() && (location = ((Registry)registryOptional.get()).getKey((Object)piglin.getType())) != null) {
                    String piglinName = location.getPath();
                    ziglin.setData(PPDataAttachments.TRANSFORMATION_TRACKER.get(), (Object)piglinName);
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)ziglin, (CustomPacketPayload)new ZiglinCapabilitySyncPacket(ziglin.getId(), piglinName), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootDropEntity(LivingDropsEvent event) {
        PiglinBrute brute;
        ItemStack itemstack;
        PiglinSkullBlock.spawnSkullIfValidKill(event.getSource(), (Entity)event.getEntity(), e -> e.getType() == EntityType.PIGLIN ? Items.PIGLIN_HEAD : PPItems.headItem(e.getType()));
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof PiglinBrute && (itemstack = (brute = (PiglinBrute)livingEntity).getOffhandItem()).getItem() instanceof BucklerItem) {
            float f = ((Double)PPConfig.COMMON.bucklerChanceToDrop.get()).floatValue();
            f = EnchantmentHelper.processEquipmentDropChance((ServerLevel)((ServerLevel)brute.level()), (LivingEntity)brute, (DamageSource)event.getSource(), (float)f);
            if (!itemstack.isEmpty() && !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) && event.isRecentlyHit() && brute.getRandom().nextFloat() < f) {
                if (itemstack.isDamageableItem()) {
                    int halvedMaxDurability = Math.abs(brute.getRandom().nextInt(Math.abs(itemstack.getMaxDamage() / 2)));
                    itemstack.setDamageValue(Math.abs(brute.getRandom().nextInt(halvedMaxDurability)));
                }
                brute.spawnAtLocation(itemstack);
                brute.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
            }
        }
    }

    @SubscribeEvent
    public static void noteBlockPlay(NoteBlockEvent.Play event) {
        BlockState stateAbove = event.getLevel().getBlockState(event.getPos().above());
        Block block = stateAbove.getBlock();
        if (block instanceof PiglinSkullBlock) {
            PiglinSkullBlock skull = (PiglinSkullBlock)block;
            event.setCanceled(true);
            event.getLevel().playSound(null, event.getPos(), skull.getType().getSoundEvent(), SoundSource.RECORDS);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && level.dimension() == Level.NETHER) {
            TravelerSpawner.tick(level, (TravelerSpawner.SpawnDelay)level.getDataStorage().computeIfAbsent(TravelerSpawner.SpawnDelay.factory(), "traveler_spawn_delay"));
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        CompassCanFindLocationCondition.clearSearchCache();
    }
}

