/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import appeng.core.definitions.ItemDefinition;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.blocks.AAEAbstractCraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.blocks.QuantumCrafterBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.ae2addonlib.datagen.AE2AddonModelProvider;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;

public class AAEModelProvider
extends AE2AddonModelProvider {
    public AAEModelProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "advanced_ae", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.basicItem(AAEItems.ADV_PROCESSING_PATTERN);
        this.basicItem(AAEItems.ADV_PATTERN_PROVIDER_UPGRADE);
        this.basicItem(AAEItems.ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE);
        this.basicItem(AAEItems.ADV_PATTERN_ENCODER);
        this.basicItem(AAEItems.SHATTERED_SINGULARITY);
        this.basicItem(AAEItems.QUANTUM_INFUSED_DUST);
        this.basicItem(AAEItems.QUANTUM_ALLOY);
        this.basicItem(AAEItems.QUANTUM_ALLOY_PLATE);
        this.basicItem(AAEItems.QUANTUM_PROCESSOR_PRESS);
        this.basicItem(AAEItems.QUANTUM_PROCESSOR_PRINT);
        this.basicItem(AAEItems.QUANTUM_PROCESSOR);
        this.basicItem(AAEItems.QUANTUM_STORAGE_COMPONENT);
        this.basicItem(AAEItems.MONITOR_CONFIGURATOR);
        this.basicItem(AAEItems.QUANTUM_CRAFTER_WIRELESS_TERMINAL);
        this.coloredItem(AAEItems.QUANTUM_HELMET);
        this.coloredItem(AAEItems.QUANTUM_CHESTPLATE);
        this.coloredItem(AAEItems.QUANTUM_LEGGINGS);
        this.coloredItem(AAEItems.QUANTUM_BOOTS);
        this.stairsBlock(AAEBlocks.QUANTUM_ALLOY_STAIRS, AAEBlocks.QUANTUM_ALLOY_BLOCK);
        this.slabBlock(AAEBlocks.QUANTUM_ALLOY_SLAB, AAEBlocks.QUANTUM_ALLOY_BLOCK);
        this.wall(AAEBlocks.QUANTUM_ALLOY_WALL, "block/quantum_alloy_block");
        for (ItemDefinition<?> card : AAEItems.getQuantumCards()) {
            this.basicItem(card, "upgrades");
        }
        this.quantumCrafterModel();
        for (AAECraftingUnitType type : AAECraftingUnitType.values()) {
            if (type == AAECraftingUnitType.QUANTUM_CORE || type == AAECraftingUnitType.STRUCTURE) continue;
            Block craftingBlock = type.getDefinition().block();
            String name = type.getAffix();
            BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + name, AdvancedAE.makeId("block/crafting/" + name));
            this.getVariantBuilder(craftingBlock).partialState().with((Property)AAEAbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)blockModel)}).partialState().with((Property)AAEAbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getBuilder("block/crafting/" + name + "_formed"))});
            this.simpleBlockItem(craftingBlock, (ModelFile)blockModel);
        }
        this.partItem(AAEItems.ADV_PATTERN_PROVIDER);
        this.partItem(AAEItems.SMALL_ADV_PATTERN_PROVIDER);
        this.partItem(AAEItems.STOCK_EXPORT_BUS, true);
        this.partItem(AAEItems.IMPORT_EXPORT_BUS, true);
        this.partItem(AAEItems.ADVANCED_IO_BUS, true);
        this.patternProvider(AAEBlocks.ADV_PATTERN_PROVIDER);
        this.patternProvider(AAEBlocks.SMALL_ADV_PATTERN_PROVIDER);
        for (FluidDefinition fluid : AAEFluids.INSTANCE.getFluids()) {
            this.waterBasedFluid(fluid);
        }
    }

    private void basicCraftingBlockModel(AAECraftingUnitType type) {
        Block craftingBlock = type.getDefinition().block();
        BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + type.getAffix(), AdvancedAE.makeId("block/crafting/" + type.getAffix()));
        this.simpleBlockItem(craftingBlock, (ModelFile)blockModel);
        this.simpleBlock(craftingBlock, (ModelFile)blockModel);
    }

    private void quantumCrafterModel() {
        ResourceLocation grid = AdvancedAE.makeId("block/quantum_crafter_grid");
        ResourceLocation gridOn = AdvancedAE.makeId("block/quantum_crafter_grid_on");
        ResourceLocation bottom = AdvancedAE.makeId("block/quantum_crafter_bottom");
        ResourceLocation sides = AdvancedAE.makeId("block/quantum_crafter_side");
        QuantumCrafterBlock block = (QuantumCrafterBlock)AAEBlocks.QUANTUM_CRAFTER.block();
        BlockModelBuilder blockModel = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeBottomTop("quantum_crafter", sides, bottom, grid)).texture("north", grid);
        BlockModelBuilder blockModelOn = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeBottomTop("quantum_crafter_on", sides, bottom, gridOn)).texture("north", gridOn);
        this.multiVariantGenerator(AAEBlocks.QUANTUM_CRAFTER, new Variant[]{Variant.variant()}).with(PropertyDispatch.property((Property)QuantumCrafterBlock.WORKING).generate(working -> {
            BlockModelBuilder model = working != false ? blockModelOn : blockModel;
            return Variant.variant().with(VariantProperties.MODEL, (Object)model.getLocation());
        })).with(AAEModelProvider.createFacingSpinDispatch());
        this.simpleBlockItem((Block)block, (ModelFile)blockModelOn);
    }
}

