/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.KeyTypeSelection;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.helpers.FilteredImportStackTransferContext;
import org.jetbrains.annotations.Nullable;

public class ImportExportBusPart
extends ExportBusPart {
    public static final ResourceLocation MODEL_BASE = AdvancedAE.makeId("part/import_export_bus_part");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_has_channel")});
    @Nullable
    private StackImportStrategy importStrategy;
    private final KeyTypeSelection keyTypeSelection = new KeyTypeSelection(() -> {
        this.getHost().markForSave();
        this.importStrategy = null;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }, StackWorldBehaviors.hasImportStrategyTypeFilter());

    public ImportExportBusPart(IPartItem<?> partItem) {
        super(partItem);
    }

    public StackImportStrategy getImportStrategy() {
        if (this.importStrategy == null) {
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos fromPos = self.getBlockPos().relative(this.getSide());
            Direction fromSide = this.getSide().getOpposite();
            this.importStrategy = StackWorldBehaviors.createImportFacade((ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)fromPos, (Direction)fromSide, (Predicate)this.keyTypeSelection.enabledPredicate());
        }
        return this.importStrategy;
    }

    protected boolean doBusWork(IGrid grid) {
        boolean exportWork = super.doBusWork(grid);
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        StackImportStrategy strategy = this.getImportStrategy();
        FilteredImportStackTransferContext context = new FilteredImportStackTransferContext(grid.getStorageService(), (IEnergySource)grid.getEnergyService(), this.source, this.getOperationsPerTick(), this.getFilter());
        context.setInverted(this.isUpgradedWith((ItemLike)AEItems.INVERTER_CARD));
        strategy.transfer((StackTransferContext)context);
        boolean importWork = context.hasDoneWork();
        return exportWork || importWork;
    }

    protected MenuType<?> getMenuType() {
        return AAEMenus.IMPORT_EXPORT_BUS.get();
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.open(AAEMenus.IMPORT_EXPORT_BUS.get(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return this.getPartItem().asItem().getDefaultInstance();
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

