/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public interface FluidContainingItem {
    default public int getMaxMB() {
        return 8000;
    }

    public static int getAvailableFluid(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return -1;
        }
        return fluidHandler.getFluidInTank(0).getAmount();
    }

    default public boolean isFluidBarVisible(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        return fluidHandler.getFluidInTank(0).getAmount() < fluidHandler.getTankCapacity(0);
    }

    default public int getFluidBarWidth(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return 13;
        }
        return Math.min(Math.round((float)fluidHandler.getFluidInTank(0).getAmount() * 13.0f / (float)fluidHandler.getTankCapacity(0)), 13);
    }

    default public int getFluidBarColor(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return -1;
        }
        float hue = 0.55f;
        float saturation = 1.0f;
        return Mth.hsvToRgb((float)hue, (float)saturation, (float)1.0f);
    }

    public static boolean hasEnoughFluid(ItemStack itemStack, int amt) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        return fluidHandler.getFluidInTank(0).getAmount() >= amt;
    }

    public static void consumeFluid(ItemStack itemStack, int amt) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        fluidHandler.drain(amt, IFluidHandler.FluidAction.EXECUTE);
    }

    public static LiquidBlock getLiquidBlockAt(Level level, BlockPos blockPos) {
        Block block = level.getBlockState(blockPos).getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return liquidBlock;
        }
        return null;
    }

    public static boolean pickupFluid(Level level, Player player, ItemStack itemStack, BlockHitResult blockhitresult) {
        BlockPos blockpos = blockhitresult.getBlockPos();
        BlockState blockstate1 = level.getBlockState(blockpos);
        LiquidBlock liquidBlock = FluidContainingItem.getLiquidBlockAt(player.level(), blockpos);
        if (liquidBlock == null) {
            return false;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        int filledAmt = fluidHandler.fill(new FluidStack((Fluid)liquidBlock.fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
        if (filledAmt == 1000) {
            ItemStack itemstack2 = liquidBlock.pickupBlock(player, (LevelAccessor)level, blockpos, blockstate1);
            fluidHandler.fill(new FluidStack((Fluid)liquidBlock.fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            liquidBlock.getPickupSound(blockstate1).ifPresent(p_150709_ -> player.playSound(p_150709_, 1.0f, 1.0f));
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack2);
            }
            return true;
        }
        return false;
    }
}

