/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.PartEntity;

public class BlockSwapperT1BE
extends BaseMachineBE
implements RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = this.getDefaultRedstoneData();
    List<BlockPos> positions = new ArrayList<BlockPos>();
    public GlobalPos boundTo;
    public final ContainerData swapperData;
    public boolean doesPartnerExist;
    public List<BlockPos> thisValidationList = new ArrayList<BlockPos>();
    public List<BlockPos> thatValidationList = new ArrayList<BlockPos>();
    public boolean swapBlocks = true;
    public SWAP_ENTITY_TYPE swap_entity_type = SWAP_ENTITY_TYPE.NONE;
    public List<Entity> entities = new ArrayList<Entity>();

    @Override
    public RedstoneControlData getDefaultRedstoneData() {
        return new RedstoneControlData(MiscHelpers.RedstoneMode.PULSE);
    }

    public BlockSwapperT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.swapperData = new ContainerData(){

            public int get(int index) {
                BlockSwapperT1BE.this.doesPartnerExist();
                return switch (index) {
                    case 0 -> {
                        if (BlockSwapperT1BE.this.doesPartnerExist) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> throw new IllegalArgumentException("Invalid index: " + index);
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        BlockSwapperT1BE.this.setPartnerExist(value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid index: " + index);
                    }
                }
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public BlockSwapperT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.BlockSwapperT1BE.get(), pPos, pBlockState);
    }

    public void setSwapperSettings(boolean swapBlocks, int swap_entity_type) {
        this.swapBlocks = swapBlocks;
        this.swap_entity_type = SWAP_ENTITY_TYPE.values()[swap_entity_type];
        this.markDirtyClient();
    }

    public boolean isPartnerNodeConnected(GlobalPos globalPos) {
        return globalPos != null && globalPos.equals((Object)this.boundTo);
    }

    public void setBoundTo(GlobalPos globalPos) {
        this.boundTo = globalPos;
        this.markDirtyClient();
    }

    public ServerLevel getPartnerLevel() {
        if (this.boundTo == null) {
            return null;
        }
        if (this.level == null) {
            return null;
        }
        return this.level.getServer().getLevel(this.boundTo.dimension());
    }

    public BlockSwapperT1BE getPartnerBE() {
        if (this.boundTo == null) {
            return null;
        }
        ServerLevel partnerLevel = this.getPartnerLevel();
        if (partnerLevel == null) {
            return null;
        }
        BlockEntity partnerBE = partnerLevel.getBlockEntity(this.boundTo.pos());
        if (!(partnerBE instanceof BlockSwapperT1BE)) {
            return null;
        }
        BlockSwapperT1BE blockSwapperT1BE = (BlockSwapperT1BE)partnerBE;
        return blockSwapperT1BE;
    }

    public GlobalPos getGlobalPos() {
        return GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.getBlockPos());
    }

    public boolean isValidPartner(BlockEntity blockEntity) {
        return blockEntity.getClass() == this.getClass();
    }

    public boolean handleConnection(GlobalPos globalPos) {
        if (this.level == null) {
            return false;
        }
        if (globalPos.equals((Object)this.getGlobalPos())) {
            return false;
        }
        ServerLevel partnerLevel = this.level.getServer().getLevel(globalPos.dimension());
        BlockEntity partnerBE = partnerLevel.getBlockEntity(globalPos.pos());
        if (!this.isValidPartner(partnerBE)) {
            return false;
        }
        if (!(partnerBE instanceof BlockSwapperT1BE)) {
            return false;
        }
        BlockSwapperT1BE blockSwapperT1BE = (BlockSwapperT1BE)partnerBE;
        if (this.isPartnerNodeConnected(globalPos)) {
            this.removePartnerConnection();
            return false;
        }
        this.addPartnerConnection(globalPos, blockSwapperT1BE);
        return true;
    }

    public GlobalPos getBoundTo() {
        return this.boundTo;
    }

    public void addPartnerConnection(GlobalPos connectingPos, BlockSwapperT1BE be) {
        if (this.getBoundTo() != null) {
            this.removePartnerConnection();
        }
        if (be.getBoundTo() != null) {
            be.removePartnerConnection();
        }
        this.setBoundTo(connectingPos);
        be.setBoundTo(this.getGlobalPos());
    }

    public void removePartnerConnection() {
        ServerLevel partnerLevel;
        BlockEntity partnerBE;
        GlobalPos partnerPos = this.getBoundTo();
        if (partnerPos != null && (partnerBE = (partnerLevel = this.level.getServer().getLevel(partnerPos.dimension())).getBlockEntity(partnerPos.pos())) instanceof BlockSwapperT1BE) {
            BlockSwapperT1BE be = (BlockSwapperT1BE)partnerBE;
            be.setBoundTo(null);
        }
        this.setBoundTo(null);
    }

    public void validateConnections() {
        if (this.boundTo == null || this.level == null || this.level.isClientSide) {
            return;
        }
        BlockSwapperT1BE blockSwapperT1BE = this.getPartnerBE();
        if (blockSwapperT1BE != null) {
            this.addPartnerConnection(this.boundTo, blockSwapperT1BE);
        }
    }

    public boolean setPartnerExist(int value) {
        this.doesPartnerExist = value == 1;
        return this.doesPartnerExist;
    }

    public void doesPartnerExist() {
        if (this.boundTo == null || this.level == null || this.level.isClientSide) {
            return;
        }
        BlockSwapperT1BE blockSwapperT1BE = this.getPartnerBE();
        this.doesPartnerExist = blockSwapperT1BE != null;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doSwap();
    }

    public boolean canSwap() {
        return true;
    }

    public void postSwap(int numBlocks) {
    }

    public void doSwap() {
        if (!this.isActiveRedstone() || !this.canRun()) {
            return;
        }
        if (!this.canSwap()) {
            return;
        }
        if (this.level == null) {
            return;
        }
        BlockSwapperT1BE remoteSwapper = this.getPartnerBE();
        if (remoteSwapper == null) {
            return;
        }
        ServerLevel partnerLevel = this.getPartnerLevel();
        if (partnerLevel == null) {
            return;
        }
        FakePlayer fakePlayer = this.getFakePlayer((ServerLevel)this.level);
        FakePlayer partnerFakePlayer = this.getFakePlayer(partnerLevel);
        if (this.swapBlocks) {
            this.positions = this.findSpotsToSwap();
        }
        if (!this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.NONE)) {
            this.entities = this.findEntitiesToSwap(this.getAABB());
        }
        if (this.positions.isEmpty() && this.entities.isEmpty()) {
            return;
        }
        for (BlockPos blockPos : this.positions) {
            this.swapBlock(blockPos, remoteSwapper, partnerLevel, fakePlayer, partnerFakePlayer);
        }
        for (BlockPos thisPos : this.thisValidationList) {
            this.validateBlock((ServerLevel)this.level, thisPos);
        }
        for (BlockPos thatPos : this.thatValidationList) {
            this.validateBlock(partnerLevel, thatPos);
        }
        for (Entity entity : this.entities) {
            this.swapEntity(entity, remoteSwapper, partnerLevel);
        }
        int totalSwapped = this.thisValidationList.size() + this.thatValidationList.size() + this.entities.size();
        this.postSwap(totalSwapped);
        if (totalSwapped > 0) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.SHULKER_TELEPORT, SoundSource.BLOCKS, 0.33f, 1.0f);
            partnerLevel.playSound(null, remoteSwapper.getBlockPos(), SoundEvents.SHULKER_TELEPORT, SoundSource.BLOCKS, 0.33f, 1.0f);
        }
        this.positions.clear();
        this.entities.clear();
        this.thisValidationList.clear();
        this.thatValidationList.clear();
    }

    public void swapEntity(Entity entity, BlockSwapperT1BE remoteSwapper, ServerLevel partnerLevel) {
        Vec3 remotePosition = remoteSwapper.getWorldPos(this.getRelativePos(entity.position()));
        entity.teleportTo(partnerLevel, remotePosition.x, remotePosition.y, remotePosition.z, new HashSet(), entity.getYRot(), entity.getXRot());
    }

    public AABB getAABB() {
        return new AABB(this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)));
    }

    public List<Entity> findEntitiesToSwap(AABB aabb) {
        ArrayList<Entity> returnList = new ArrayList<Entity>(this.level.getEntitiesOfClass(Entity.class, aabb, this::isValidEntity));
        return returnList;
    }

    public boolean isSameLevel() {
        return this.level.equals(this.getPartnerBE().getLevel());
    }

    public boolean isValidEntity(Entity entity) {
        Animal animal;
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        if (!entity.canChangeDimensions(this.level, this.getPartnerBE().level) && !this.isSameLevel()) {
            return false;
        }
        if (entity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED)) {
            return false;
        }
        if (this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.HOSTILE) && !(entity instanceof Monster)) {
            return false;
        }
        if ((this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.PASSIVE) || this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.ADULT) || this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.CHILD)) && !(entity instanceof Animal)) {
            return false;
        }
        if (this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.ADULT) && entity instanceof Animal && (animal = (Animal)entity).isBaby()) {
            return false;
        }
        if (this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.CHILD) && entity instanceof Animal && !(animal = (Animal)entity).isBaby()) {
            return false;
        }
        if (this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.PLAYER) && !(entity instanceof Player)) {
            return false;
        }
        return !this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.ITEM) || entity instanceof ItemEntity;
    }

    public void swapBlock(BlockPos blockPos, BlockSwapperT1BE remoteSwapper, ServerLevel partnerLevel, FakePlayer fakePlayer, FakePlayer partnerFakePlayer) {
        BlockEntity newBE;
        BlockEntity newBE2;
        BlockPos remoteSwapPos = remoteSwapper.getWorldPos(this.getRelativePos(blockPos));
        if (!this.isBlockPosValid(partnerLevel, remoteSwapPos)) {
            return;
        }
        if (!this.canBreakAndPlaceAt(this.level, blockPos, fakePlayer)) {
            return;
        }
        if (!this.canBreakAndPlaceAt((Level)partnerLevel, remoteSwapPos, partnerFakePlayer)) {
            return;
        }
        BlockState thisBlock = this.level.getBlockState(blockPos);
        BlockState thatBlock = partnerLevel.getBlockState(remoteSwapPos);
        if (thisBlock.isAir() && thatBlock.isAir()) {
            return;
        }
        BlockEntity thisBE = this.level.getBlockEntity(blockPos);
        BlockEntity thatBE = partnerLevel.getBlockEntity(remoteSwapPos);
        CompoundTag thisNBT = new CompoundTag();
        CompoundTag thatNBT = new CompoundTag();
        if (thisBE != null) {
            thisNBT = thisBE.saveWithFullMetadata((HolderLookup.Provider)this.level.registryAccess());
        }
        if (thatBE != null) {
            thatNBT = thatBE.saveWithFullMetadata((HolderLookup.Provider)this.level.registryAccess());
        }
        this.level.removeBlockEntity(blockPos);
        partnerLevel.removeBlockEntity(remoteSwapPos);
        boolean placedThat = partnerLevel.setBlock(remoteSwapPos, thisBlock, 51);
        if ((placedThat || partnerLevel.getBlockState(remoteSwapPos).equals(thisBlock)) && !thisNBT.isEmpty() && (newBE2 = partnerLevel.getBlockEntity(remoteSwapPos)) != null) {
            try {
                newBE2.loadCustomOnly(thisNBT, (HolderLookup.Provider)this.level.registryAccess());
            }
            catch (Exception e) {
                System.out.println("Failed to restore tile data for block at: " + String.valueOf(remoteSwapPos) + " with NBT: " + String.valueOf(thisNBT) + ". Consider adding it to the blacklist");
            }
        }
        this.thatValidationList.add(remoteSwapPos);
        boolean placedThis = this.level.setBlock(blockPos, thatBlock, 51);
        if ((placedThis || this.level.getBlockState(blockPos).equals(thatBlock)) && !thatNBT.isEmpty() && (newBE = this.level.getBlockEntity(blockPos)) != null) {
            try {
                newBE.loadCustomOnly(thatNBT, (HolderLookup.Provider)this.level.registryAccess());
            }
            catch (Exception e) {
                System.out.println("Failed to restore tile data for block at: " + String.valueOf(blockPos) + " with NBT: " + String.valueOf(thatNBT) + ". Consider adding it to the blacklist");
            }
        }
        this.thisValidationList.add(blockPos);
        BlockSwapperT1BE.teleportParticles((ServerLevel)this.level, blockPos);
        BlockSwapperT1BE.teleportParticles(partnerLevel, remoteSwapPos);
    }

    public void validateBlock(ServerLevel level, BlockPos blockPos) {
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            level.destroyBlock(blockPos, true);
            return;
        }
        BlockState adjustedBlockState = Block.updateFromNeighbourShapes((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos);
        if (!adjustedBlockState.equals(blockState)) {
            level.setBlockAndUpdate(blockPos, adjustedBlockState);
        } else {
            LevelChunk levelchunk = level.getChunkAt(blockPos);
            level.markAndNotifyBlock(blockPos, levelchunk, blockState, blockState, 3, 512);
        }
    }

    public static void teleportParticles(ServerLevel level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() - 0.5 + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isBlockPosValid(ServerLevel serverLevel, BlockPos blockPos) {
        BlockState blockState = serverLevel.getBlockState(blockPos);
        if (blockState.is(Tags.Blocks.RELOCATION_NOT_SUPPORTED) || blockState.is(JustDireBlockTags.SWAPPERDENY)) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)serverLevel, blockPos) < 0.0f) {
            return false;
        }
        GlobalPos targetGlobalPos = GlobalPos.of((ResourceKey)serverLevel.dimension(), (BlockPos)blockPos);
        return !targetGlobalPos.equals((Object)this.getGlobalPos()) && !targetGlobalPos.equals((Object)this.boundTo);
    }

    public BlockPos getStartingPoint() {
        return this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
    }

    public List<BlockPos> findSpotsToSwap() {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid((ServerLevel)this.level, blockPos)) {
            returnList.add(blockPos);
        }
        return returnList;
    }

    public BlockPos getWorldPos(BlockPos relativePos) {
        return this.getStartingPoint().offset((Vec3i)relativePos);
    }

    public BlockPos getRelativePos(BlockPos worldPos) {
        return worldPos.subtract((Vec3i)this.getStartingPoint());
    }

    public Vec3 getWorldPos(Vec3 relativePos) {
        return new Vec3((double)this.getStartingPoint().getX() + relativePos.x, (double)this.getStartingPoint().getY() + relativePos.y, (double)this.getStartingPoint().getZ() + relativePos.z);
    }

    public Vec3 getRelativePos(Vec3 worldPos) {
        return new Vec3(worldPos.x - (double)this.getStartingPoint().getX(), worldPos.y - (double)this.getStartingPoint().getY(), worldPos.z - (double)this.getStartingPoint().getZ());
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (this.boundTo != null) {
            return false;
        }
        if (!this.swapBlocks) {
            return false;
        }
        return this.swap_entity_type.equals((Object)SWAP_ENTITY_TYPE.NONE);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.boundTo != null) {
            tag.put("boundTo", (Tag)NBTHelpers.globalPosToNBT(this.boundTo));
        }
        tag.putBoolean("swapBlocks", this.swapBlocks);
        tag.putInt("swap_entity_type", this.swap_entity_type.ordinal());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("boundTo")) {
            GlobalPos newBoundTo = NBTHelpers.nbtToGlobalPos(tag.getCompound("boundTo"));
            boolean same = newBoundTo.equals((Object)this.boundTo);
            this.boundTo = newBoundTo;
            if (!same) {
                this.validateConnections();
            }
        } else {
            this.boundTo = null;
        }
        if (tag.contains("swapBlocks")) {
            this.swapBlocks = tag.getBoolean("swapBlocks");
        }
        this.swap_entity_type = SWAP_ENTITY_TYPE.values()[tag.getInt("swap_entity_type")];
    }

    public static enum SWAP_ENTITY_TYPE {
        NONE,
        HOSTILE,
        PASSIVE,
        ADULT,
        CHILD,
        PLAYER,
        LIVING,
        ITEM,
        ALL;


        public SWAP_ENTITY_TYPE next() {
            SWAP_ENTITY_TYPE[] values = SWAP_ENTITY_TYPE.values();
            int nextOrdinal = (this.ordinal() + 1) % values.length;
            return values[nextOrdinal];
        }
    }
}

