/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.widgets;

import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.BaseButton;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ToggleButton
extends BaseButton {
    private List<ToggleButtonFactory.TextureLocalization> textureLocalizations;
    private int texturePosition;
    private int maxValue = -1;

    public ToggleButton(int x, int y, int width, int height, List<ToggleButtonFactory.TextureLocalization> textureLocalizations, int texturePosition, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.textureLocalizations = textureLocalizations;
        this.setTexturePosition(texturePosition);
    }

    public ToggleButton(int x, int y, int width, int height, List<ToggleButtonFactory.TextureLocalization> textureLocalizations, int texturePosition, int maxValue, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.textureLocalizations = textureLocalizations;
        this.setTexturePosition(texturePosition);
        this.maxValue = maxValue;
    }

    public ToggleButton(int x, int y, int width, int height, List<ToggleButtonFactory.TextureLocalization> textureLocalizations, boolean texturePosition, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.textureLocalizations = textureLocalizations;
        this.setTexturePosition(texturePosition);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureLocalizations.get(this.getTexturePosition()).texture());
        guiGraphics.blit(this.textureLocalizations.get(this.getTexturePosition()).texture(), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    public void onClick(double p_onClick_1_, double p_onClick_3_) {
        super.onClick(p_onClick_1_, p_onClick_3_);
    }

    public boolean mouseClicked(double x, double y, int button) {
        return super.mouseClicked(x, y, button);
    }

    public int getTexturePosition() {
        return this.texturePosition >= this.textureLocalizations.size() ? 0 : this.texturePosition;
    }

    public void setTexturePosition(boolean texturePosition) {
        this.setTexturePosition(texturePosition ? 1 : 0);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.previousTexturePosition();
        } else {
            this.nextTexturePosition();
        }
        this.onPress();
    }

    public void setTexturePosition(int texturePosition) {
        this.texturePosition = texturePosition >= this.textureLocalizations.size() ? this.textureLocalizations.size() : texturePosition;
    }

    public void nextTexturePosition() {
        this.texturePosition = this.maxValue == -1 ? (this.getTexturePosition() + 1) % this.textureLocalizations.size() : (this.getTexturePosition() + 1) % Math.min(this.textureLocalizations.size(), this.maxValue);
    }

    @Override
    public Component getLocalization() {
        return this.textureLocalizations.get(this.getTexturePosition()).localization();
    }

    public void previousTexturePosition() {
        if (this.maxValue == -1) {
            int size = this.textureLocalizations.size();
            this.texturePosition = (this.getTexturePosition() - 1 + size) % size;
        } else {
            int limit = Math.min(this.textureLocalizations.size(), this.maxValue);
            this.texturePosition = (this.getTexturePosition() - 1 + limit) % limit;
        }
    }
}

