/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.jei;

import com.direwolf20.justdirethings.client.jei.OreToResourceRecipe;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class OreToResourceCategory
implements IRecipeCategory<OreToResourceRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable pickaxeIcon;
    private final IDrawableAnimated animatedArrow;
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"ore_to_resource");

    public OreToResourceCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 30);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Registration.RawFerricoreOre.get()));
        IDrawableStatic arrowDrawable = guiHelper.getRecipeArrow();
        this.animatedArrow = guiHelper.createAnimatedDrawable(arrowDrawable, 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.pickaxeIcon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.IRON_PICKAXE));
    }

    public RecipeType<OreToResourceRecipe> getRecipeType() {
        return new RecipeType(UID, OreToResourceRecipe.class);
    }

    public Component getTitle() {
        return Component.translatable((String)"justdirethings.oretoresource.title");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(OreToResourceRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.animatedArrow.draw(gui, 46, 10);
        this.background.draw(gui, 17, 0);
        this.pickaxeIcon.draw(gui, 50, -2);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OreToResourceRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 10).addItemStack(recipe.getOreBlock());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 10).addItemStack(recipe.getOutput());
    }
}

