/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.machines.blockentities.multiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.IOMachines;
import dev.wp.industrialization_overdrive.datamap.PyrolyseOvenTier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformers;
import net.swedz.tesseract.neoforge.compat.mi.helper.CommonGuiComponents;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractElectricMultipliedCraftingMultiblockBlockEntity;

public final class PyrolyseOvenBlockEntity
extends AbstractElectricMultipliedCraftingMultiblockBlockEntity {
    private static List<Tier> TIERS = List.of();
    private static Map<ResourceLocation, Tier> TIERS_BY_COIL = Collections.unmodifiableMap(Maps.newHashMap());
    private static ShapeTemplate[] SHAPE_TEMPLATES = new ShapeTemplate[0];

    public PyrolyseOvenBlockEntity(BEP bep) {
        super(bep, IO.id("pyrolyse_oven"), SHAPE_TEMPLATES, MachineTier.MULTIBLOCK);
        List<Component> tierComponents = TIERS.stream().map(Tier::getDisplayName).toList();
        this.registerGuiComponent(new GuiComponentServer[]{CommonGuiComponents.rangedShapeSelection((MultiblockMachineBlockEntity)this, (ActiveShapeComponent)this.activeShape, tierComponents, (boolean)true)});
    }

    public Tier getActiveTier() {
        return TIERS.get(this.activeShape.getActiveShapeIndex());
    }

    public MachineRecipeType getRecipeType() {
        return IOMachines.RecipeTypes.PYROLYSE_OVEN;
    }

    public int getMaxMultiplier() {
        return this.getActiveTier().batchSize();
    }

    public EuCostTransformer getEuCostTransformer() {
        return EuCostTransformers.percentage(() -> Float.valueOf(this.getActiveTier().euCostMultiplier()));
    }

    public List<Component> getTooltips() {
        return List.of(TesseractMI.text().machineBatcherRecipe(true, MIMachineRecipeTypes.COKE_OVEN), IO.text().machineBatcherCoils());
    }

    public static List<Tier> getTiers() {
        return TIERS;
    }

    public static Map<ResourceLocation, Tier> getTiersByCoil() {
        return TIERS_BY_COIL;
    }

    public static void initTiers() {
        ArrayList tiers = Lists.newArrayList();
        PyrolyseOvenTier.getAll().forEach((block, tier) -> tiers.add(new Tier(block.location(), tier.batchSize(), tier.euCostMultiplier())));
        tiers.sort(Comparator.comparingInt(Tier::batchSize));
        TIERS = Collections.unmodifiableList(tiers);
        TIERS_BY_COIL = TIERS.stream().collect(Collectors.toMap(Tier::blockId, Function.identity()));
        SHAPE_TEMPLATES = new ShapeTemplate[TIERS.size()];
        SimpleMember casing = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"bronze_plated_bricks"))));
        HatchFlags hatches = new HatchFlags.Builder().with(new HatchType[]{HatchTypes.FLUID_INPUT, HatchTypes.FLUID_OUTPUT, HatchTypes.ITEM_INPUT, HatchTypes.ITEM_OUTPUT, HatchTypes.ENERGY_INPUT}).build();
        for (int i = 0; i < TIERS.size(); ++i) {
            Tier tier2 = TIERS.get(i);
            SimpleMember coil = SimpleMember.forBlockId((ResourceLocation)tier2.blockId());
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.BRONZE_PLATED_BRICKS);
            for (int z = 0; z < 4; ++z) {
                boolean isFront = z == 0;
                boolean isBack = z == 3;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        boolean isCenter;
                        boolean bl = isCenter = x == 0 && y == 0;
                        if (isFront || isBack) {
                            builder.add(x, y, z, casing, hatches);
                            continue;
                        }
                        if (isCenter) continue;
                        builder.add(x, y, z, coil);
                    }
                }
            }
            PyrolyseOvenBlockEntity.SHAPE_TEMPLATES[i] = builder.build();
        }
        PyrolyseOvenBlockEntity.registerReiShapes();
    }

    private static void registerReiShapes() {
        ReiMachineRecipes.multiblockShapes.removeIf(e -> e.machine().equals((Object)IO.id("pyrolyse_oven")));
        int index = 0;
        for (ShapeTemplate shapeTemplate : SHAPE_TEMPLATES) {
            ReiMachineRecipes.registerMultiblockShape((ResourceLocation)IO.id("pyrolyse_oven"), (ShapeTemplate)shapeTemplate, (String)("" + index));
            ++index;
        }
    }

    public record Tier(ResourceLocation blockId, int batchSize, float euCostMultiplier) {
        public String getTranslationKey() {
            return "pyro_tier.%s.%s.%s".formatted("industrialization_overdrive", this.blockId.getNamespace(), this.blockId.getPath());
        }

        public Component getDisplayName() {
            return Component.translatable((String)this.getTranslationKey());
        }
    }
}

