/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.compat;

import appeng.api.config.Actionable;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import dev.wp.industrialization_overdrive.IOItems;
import dev.wp.industrialization_overdrive.item.Terminal;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AE2Integration {
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();

    public static void registerItems() {
        GridLinkables.register((ItemLike)IOItems.TERMINAL.get(), (IGridLinkableHandler)LINKABLE_HANDLER);
    }

    public static Map<Item, Integer> simulateExtractFromME(Player player, Level level, Map<Item, Integer> missingItems) {
        HashMap<Item, Integer> provided = new HashMap<Item, Integer>();
        MEStorage networkInv = AE2Integration.getMEStorage(player, level);
        if (networkInv == null) {
            return provided;
        }
        for (Map.Entry<Item, Integer> entry : missingItems.entrySet()) {
            int needed;
            Item item = entry.getKey();
            ItemStack testStack = new ItemStack((ItemLike)item, needed = entry.getValue().intValue());
            AEItemKey key = AEItemKey.of((ItemStack)testStack);
            long extracted = networkInv.extract((AEKey)key, (long)needed, Actionable.SIMULATE, IActionSource.ofPlayer((Player)player));
            if (extracted <= 0L) continue;
            provided.put(item, (int)extracted);
        }
        return provided;
    }

    public static void extractFromME(Player player, Level level, Map<Item, Integer> toExtract) {
        MEStorage networkInv = AE2Integration.getMEStorage(player, level);
        if (networkInv == null) {
            return;
        }
        for (Map.Entry<Item, Integer> entry : toExtract.entrySet()) {
            Item item = entry.getKey();
            int needed = entry.getValue();
            ItemStack testStack = new ItemStack((ItemLike)item, needed);
            AEItemKey key = AEItemKey.of((ItemStack)testStack);
            networkInv.extract((AEKey)key, (long)needed, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
        }
    }

    private static MEStorage getMEStorage(Player player, Level level) {
        ItemStack terminalStack = player.getMainHandItem();
        GlobalPos linkPos = Terminal.getLinkPos(terminalStack);
        if (linkPos == null || level == null) {
            return null;
        }
        BlockEntity be = level.getBlockEntity(linkPos.pos());
        if (!(be instanceof IWirelessAccessPoint)) {
            return null;
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
        IGrid grid = accessPoint.getGrid();
        if (grid == null) {
            return null;
        }
        return grid.getStorageService().getInventory();
    }

    public static class LinkableHandler
    implements IGridLinkableHandler {
        public boolean canLink(ItemStack stack) {
            return stack.getItem() instanceof Terminal;
        }

        public void link(ItemStack itemStack, GlobalPos pos) {
            Terminal.setLinkPos(itemStack, pos);
        }

        public void unlink(ItemStack itemStack) {
            Terminal.clearLinkPos(itemStack);
        }
    }
}

