/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.networking.Message;
import com.cmdpro.databank.worldgui.WorldGuiEntity;
import com.cmdpro.databank.worldgui.components.WorldGuiComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record WorldGuiInteractC2SPacket(int entity, int interactionType, int x, int y) implements Message
{
    public static final CustomPacketPayload.Type<WorldGuiInteractC2SPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("world_gui_interact"));

    public static WorldGuiInteractC2SPacket read(FriendlyByteBuf buf) {
        int entity = buf.readInt();
        int interactionType = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        return new WorldGuiInteractC2SPacket(entity, interactionType, x, y);
    }

    public static void write(FriendlyByteBuf buf, WorldGuiInteractC2SPacket obj) {
        buf.writeInt(obj.entity);
        buf.writeInt(obj.interactionType);
        buf.writeInt(obj.x);
        buf.writeInt(obj.y);
    }

    public CustomPacketPayload.Type<WorldGuiInteractC2SPacket> type() {
        return TYPE;
    }

    @Override
    public void handleServer(MinecraftServer server, ServerPlayer player, IPayloadContext context) {
        Entity entity = player.level().getEntity(this.entity);
        if (entity instanceof WorldGuiEntity) {
            WorldGuiEntity entity2 = (WorldGuiEntity)entity;
            if (entity2.gui != null) {
                switch (this.interactionType) {
                    case 0: {
                        entity2.gui.leftClick(false, (Player)player, this.x, this.y);
                        for (WorldGuiComponent i : entity2.gui.components.stream().toList()) {
                            if (!entity2.gui.tryLeftClickComponent(false, (Player)player, i, this.x, this.y)) continue;
                            i.leftClick(false, (Player)player, this.x, this.y);
                        }
                        break;
                    }
                    case 1: {
                        entity2.gui.rightClick(false, (Player)player, this.x, this.y);
                        for (WorldGuiComponent i : entity2.gui.components.stream().toList()) {
                            if (!entity2.gui.tryLeftClickComponent(false, (Player)player, i, this.x, this.y)) continue;
                            i.rightClick(false, (Player)player, this.x, this.y);
                        }
                        break;
                    }
                }
            }
        }
    }
}

