/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.multiblock;

import com.cmdpro.databank.ClientDatabankUtils;
import com.cmdpro.databank.Databank;
import com.cmdpro.databank.multiblock.Multiblock;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank")
public class MultiblockRenderer {
    public static Rotation multiblockRotation;
    public static BlockPos multiblockPos;
    public static Multiblock multiblock;
    public static MultiBufferSource.BufferSource buffers;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            event.getPoseStack().pushPose();
            event.getPoseStack().translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
            MultiblockRenderer.renderCurrentMultiblock(event.getPoseStack(), event.getPartialTick());
            event.getPoseStack().popPose();
        }
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (multiblock != null && multiblockPos != null && multiblock.checkMultiblock((Level)mc.level, multiblockPos, multiblockRotation)) {
            multiblock = null;
            multiblockPos = null;
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide() && multiblock != null && multiblockPos == null) {
            multiblockPos = event.getHitVec().getBlockPos().relative(event.getHitVec().getDirection());
            multiblockRotation = MultiblockRenderer.getRotation();
        }
    }

    public static void renderBlock(Multiblock multiblock, BlockState block, BlockPos pos, BlockPos worldPos, PoseStack stack, DeltaTracker partialTick) {
        if (buffers == null) {
            buffers = MultiblockRenderer.initBuffers(Minecraft.getInstance().renderBuffers().bufferSource());
        }
        MultiblockRenderer.renderBlock(multiblock, block, pos, worldPos, stack, partialTick, buffers);
    }

    public static void renderCurrentMultiblock(PoseStack stack, DeltaTracker partialTick) {
        if (multiblock != null) {
            if (multiblockPos == null) {
                HitResult hitResult = Minecraft.getInstance().hitResult;
                if (hitResult instanceof BlockHitResult) {
                    BlockHitResult result = (BlockHitResult)hitResult;
                    MultiblockRenderer.renderMultiblock(multiblock, result.getBlockPos().relative(result.getDirection()), stack, partialTick, MultiblockRenderer.getRotation());
                }
            } else {
                MultiblockRenderer.renderMultiblock(multiblock, multiblockPos, stack, partialTick, multiblockRotation);
            }
        }
    }

    @NotNull
    public static Rotation getRotation() {
        Rotation rot = Rotation.NONE;
        if (Minecraft.getInstance().player.getDirection().equals((Object)Direction.EAST)) {
            rot = Rotation.CLOCKWISE_90;
        }
        if (Minecraft.getInstance().player.getDirection().equals((Object)Direction.SOUTH)) {
            rot = Rotation.CLOCKWISE_180;
        }
        if (Minecraft.getInstance().player.getDirection().equals((Object)Direction.WEST)) {
            rot = Rotation.COUNTERCLOCKWISE_90;
        }
        return rot;
    }

    public static void renderMultiblock(Multiblock multiblock, BlockPos pos, PoseStack stack, DeltaTracker partialTick) {
        MultiblockRenderer.renderMultiblock(multiblock, pos, stack, partialTick, Rotation.NONE);
    }

    public static void renderMultiblock(Multiblock multiblock, BlockPos pos, PoseStack stack, DeltaTracker partialTick, Rotation rotation) {
        if (buffers == null) {
            buffers = MultiblockRenderer.initBuffers(Minecraft.getInstance().renderBuffers().bufferSource());
        }
        MultiblockRenderer.renderMultiblock(multiblock, pos, stack, partialTick, rotation, buffers);
    }

    public static void renderMultiblock(Multiblock multiblock, BlockPos pos, PoseStack stack, DeltaTracker partialTick, Rotation rotation, MultiBufferSource.BufferSource bufferSource) {
        for (List<List<Multiblock.PredicateAndPos>> i : multiblock.getStates()) {
            for (List<Multiblock.PredicateAndPos> j : i) {
                for (Multiblock.PredicateAndPos k : j) {
                    if (pos != null) {
                        BlockState state = Minecraft.getInstance().level.getBlockState(k.offset.rotate(rotation).offset((Vec3i)pos));
                        boolean stateMatches = k.predicate.isSame(state, rotation);
                        if (stateMatches) continue;
                        MultiblockRenderer.renderBlock(multiblock, k.predicate.getVisual().rotate((LevelAccessor)Minecraft.getInstance().level, k.offset, rotation), k.offset, k.offset.rotate(rotation).offset((Vec3i)pos), stack, partialTick, bufferSource);
                        continue;
                    }
                    MultiblockRenderer.renderBlock(multiblock, k.predicate.getVisual().rotate((LevelAccessor)Minecraft.getInstance().level, k.offset, rotation), k.offset, k.offset.rotate(rotation), stack, partialTick, bufferSource);
                }
            }
        }
        bufferSource.endBatch();
    }

    public static void renderBlock(Multiblock multiblock, BlockState block, BlockPos pos, BlockPos worldPos, PoseStack stack, DeltaTracker partialTick, MultiBufferSource.BufferSource bufferSource) {
        Object buffer;
        stack.pushPose();
        stack.translate((float)worldPos.getX(), (float)worldPos.getY(), (float)worldPos.getZ());
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        FluidState fluidState = block.getFluidState();
        if (!fluidState.isEmpty()) {
            RenderType layer = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
            buffer = bufferSource.getBuffer(layer);
            blockRenderer.renderLiquid(pos, (BlockAndTintGetter)multiblock, (VertexConsumer)buffer, block, fluidState);
        }
        if (block.getRenderShape() != RenderShape.INVISIBLE) {
            BakedModel model = blockRenderer.getBlockModel(block);
            buffer = model.getRenderTypes(block, Minecraft.getInstance().level.random, ModelData.EMPTY).iterator();
            while (buffer.hasNext()) {
                RenderType i = (RenderType)buffer.next();
                VertexConsumer hologramConsumer = bufferSource.getBuffer(i);
                blockRenderer.renderBatched(block, pos, (BlockAndTintGetter)multiblock, stack, hologramConsumer, false, Minecraft.getInstance().level.random, ModelData.EMPTY, i);
            }
        }
        if ((buffer = block.getBlock()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)buffer;
            BlockEntity be = multiblock.blockEntityCache.computeIfAbsent(pos.immutable(), p -> entityBlock.newBlockEntity(p, block));
            if (be != null && !multiblock.erroredBlockEntities.contains(be)) {
                be.setLevel((Level)Minecraft.getInstance().level);
                be.setBlockState(block);
                try {
                    BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
                    if (renderer != null) {
                        renderer.render(be, partialTick.getGameTimeDeltaTicks(), stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
                    }
                }
                catch (Exception e) {
                    multiblock.erroredBlockEntities.add(be);
                    Databank.LOGGER.error("[DATABANK ERROR] Error rendering block entity", (Throwable)e);
                }
            }
        }
        stack.popPose();
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        return ClientDatabankUtils.createMainBufferSourceCopy((fixedBuffers, sharedBuffer) -> {
            Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
            for (Map.Entry e : fixedBuffers.entrySet()) {
                remapped.put(HologramRenderType.remap((RenderType)e.getKey()), (ByteBufferBuilder)e.getValue());
            }
            return new HologramBuffers(sharedBuffer, (SequencedMap<RenderType, ByteBufferBuilder>)remapped);
        });
    }

    private static class HologramRenderType
    extends RenderType {
        private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private HologramRenderType(RenderType original) {
            super(String.format("%s_%s_hologram", original.toString(), "databank"), original.format(), original.mode(), original.bufferSize(), original.affectsCrumbling(), true, () -> {
                original.setupRenderState();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.clearRenderState();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof HologramRenderType) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, HologramRenderType::new);
        }
    }

    private static class HologramBuffers
    extends MultiBufferSource.BufferSource {
        protected HologramBuffers(ByteBufferBuilder fallback, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer getBuffer(RenderType type) {
            return super.getBuffer(HologramRenderType.remap(type));
        }
    }
}

