/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.model.ModelPose;
import com.cmdpro.databank.model.animation.DatabankAnimationDefinition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class DatabankAnimation {
    public static final Codec<DatabankAnimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("length").forGetter(animation -> Float.valueOf(animation.length)), (App)Codec.BOOL.fieldOf("looping").forGetter(animation -> animation.looping), (App)AnimationPart.CODEC.listOf().fieldOf("animation").forGetter(animation -> animation.animationParts)).apply((Applicative)instance, DatabankAnimation::new));
    public float length;
    public boolean looping;
    public List<AnimationPart> animationParts;
    public static final Target POSITION = ModelPose.ModelPosePart::offsetPosition;
    public static final Target ROTATION = ModelPose.ModelPosePart::offsetRotation;
    public static final Target SCALE = ModelPose.ModelPosePart::offsetScale;

    public DatabankAnimation(float length, boolean looping, List<AnimationPart> animationParts) {
        this.length = length;
        this.looping = looping;
        this.animationParts = animationParts;
    }

    public DatabankAnimationDefinition createAnimationDefinition(String id) {
        DatabankAnimationDefinition anim = new DatabankAnimationDefinition(id, this);
        return anim;
    }

    public static class AnimationPart {
        public static final Codec<AnimationPart> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("bone").forGetter(part -> part.bone), (App)Codec.STRING.fieldOf("target").forGetter(part -> part.targetString), (App)AnimationKeyframe.CODEC.listOf().fieldOf("keyframes").forGetter(part -> part.keyframes)).apply((Applicative)instance, AnimationPart::new));
        public String bone;
        public String targetString;
        public Target target;
        public List<AnimationKeyframe> keyframes;

        public AnimationPart(String bone, String target, List<AnimationKeyframe> keyframes) {
            this.bone = bone;
            this.targetString = target;
            this.keyframes = keyframes;
            if (target.equalsIgnoreCase("POSITION")) {
                this.target = POSITION;
            }
            if (target.equalsIgnoreCase("ROTATION")) {
                this.target = ROTATION;
            }
            if (target.equalsIgnoreCase("SCALE")) {
                this.target = SCALE;
            }
            for (AnimationKeyframe i : keyframes) {
                i.targetChannel = this.target;
            }
        }
    }

    public static interface Target {
        public void apply(ModelPose.ModelPosePart var1, Vector3f var2);
    }

    public static class AnimationKeyframe {
        public static final Codec<AnimationKeyframe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("timestamp").forGetter(keyframe -> Float.valueOf(keyframe.timestamp)), (App)ExtraCodecs.VECTOR3F.fieldOf("target").forGetter(keyframe -> keyframe.target), (App)Codec.STRING.fieldOf("interpolation").forGetter(keyframe -> keyframe.interpolation)).apply((Applicative)instance, AnimationKeyframe::new));
        public float timestamp;
        public Vector3f target;
        public String interpolation;
        public Target targetChannel;

        public AnimationKeyframe(float timestamp, Vector3f target, String interpolation) {
            this.timestamp = timestamp;
            this.target = target;
            this.interpolation = interpolation;
        }

        public Keyframe createKeyframe() {
            Vector3f target = this.getTarget();
            AnimationChannel.Interpolation interpolation = this.getInterpolation();
            assert (interpolation != null);
            return new Keyframe(this.timestamp, target, interpolation);
        }

        private AnimationChannel.Interpolation getInterpolation() {
            if (this.interpolation.equalsIgnoreCase("LINEAR")) {
                return AnimationChannel.Interpolations.LINEAR;
            }
            if (this.interpolation.equalsIgnoreCase("SMOOTH")) {
                return AnimationChannel.Interpolations.CATMULLROM;
            }
            return null;
        }

        private Vector3f getTarget() {
            Vector3f target = this.target;
            if (this.targetChannel == POSITION) {
                target = KeyframeAnimations.posVec((float)target.x, (float)target.y, (float)target.z);
            }
            if (this.targetChannel == ROTATION) {
                target = KeyframeAnimations.degreeVec((float)target.x, (float)target.y, (float)target.z);
            }
            if (this.targetChannel == SCALE) {
                target = KeyframeAnimations.scaleVec((double)target.x, (double)target.y, (double)target.z);
            }
            return target;
        }
    }
}

