/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.Databank;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;

public class DebugHelper {
    public static final List<String> debugText = new ArrayList<String>();
    private static final List<String> renderedText = new ArrayList<String>();

    @EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.GAME)
    protected static class GameEvents {
        protected GameEvents() {
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onClientTick(ClientTickEvent.Post event) {
            renderedText.clear();
            renderedText.addAll(debugText);
            debugText.clear();
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.MOD)
    protected static class ModEvents {
        protected ModEvents() {
        }

        @SubscribeEvent
        public static void registerGuiLayers(RegisterGuiLayersEvent event) {
            event.registerAboveAll(Databank.locate("debug"), (guiGraphics, deltaTracker) -> {
                int y = 4;
                Font font = Minecraft.getInstance().font;
                for (String i : renderedText) {
                    guiGraphics.drawString(font, i, 4, y, -1);
                    Objects.requireNonNull(font);
                    y += 9 + 2;
                }
            });
        }
    }
}

