/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megastructures.block;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.megastructures.Megastructure;
import com.cmdpro.databank.registry.AttachmentTypeRegistry;
import com.cmdpro.databank.registry.BlockEntityRegistry;
import com.cmdpro.databank.registry.BlockRegistry;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.FileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="databank")
public class MegastructureSaveBlockEntity
extends BlockEntity {
    int changeProgressTo;
    private int bindProcess;
    public BlockPos corner1;
    public BlockPos corner2;
    public BlockPos center;
    private UUID uuid;

    public MegastructureSaveBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistry.MEGASTRUCTURE_SAVE.get(), pos, blockState);
    }

    public void setBindProcess(int process) {
        this.changeProgressTo = process;
    }

    public boolean isChangingBind() {
        return this.bindProcess != this.changeProgressTo;
    }

    public int getBindProcess() {
        return this.bindProcess;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.changeProgressTo != this.bindProcess) {
            this.bindProcess = this.changeProgressTo;
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        if (tag.contains("corner1X") && tag.contains("corner1Y") && tag.contains("corner1Z")) {
            this.corner1 = new BlockPos(tag.getInt("corner1X"), tag.getInt("corner1Y"), tag.getInt("corner1Z"));
        }
        if (tag.contains("corner2X") && tag.contains("corner2Y") && tag.contains("corner2Z")) {
            this.corner2 = new BlockPos(tag.getInt("corner2X"), tag.getInt("corner2Y"), tag.getInt("corner2Z"));
        }
        if (tag.contains("centerX") && tag.contains("centerY") && tag.contains("centerZ")) {
            this.center = new BlockPos(tag.getInt("centerX"), tag.getInt("centerY"), tag.getInt("centerZ"));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        if (this.corner1 != null) {
            tag.putInt("corner1X", this.corner1.getX());
            tag.putInt("corner1Y", this.corner1.getY());
            tag.putInt("corner1Z", this.corner1.getZ());
        }
        if (this.corner2 != null) {
            tag.putInt("corner2X", this.corner2.getX());
            tag.putInt("corner2Y", this.corner2.getY());
            tag.putInt("corner2Z", this.corner2.getZ());
        }
        if (this.center != null) {
            tag.putInt("centerX", this.center.getX());
            tag.putInt("centerY", this.center.getY());
            tag.putInt("centerZ", this.center.getZ());
        }
        return tag;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            if (player.isShiftKeyDown()) {
                if (this.getBindProcess() == 0) {
                    player.sendSystemMessage((Component)Component.translatable((String)"block.databank.megastructure_save.corner1"));
                    player.setData(AttachmentTypeRegistry.BINDING_BLOCK, Optional.of(this));
                    this.setBindProcess(1);
                } else {
                    this.corner1 = null;
                    this.corner2 = null;
                    this.center = null;
                    player.setData(AttachmentTypeRegistry.BINDING_BLOCK, Optional.empty());
                    player.sendSystemMessage((Component)Component.translatable((String)"block.databank.megastructure_save.reset"));
                    this.updateBlock();
                    this.setBindProcess(0);
                }
            } else if (this.corner1 != null && this.corner2 != null && this.center != null) {
                this.save();
                player.sendSystemMessage((Component)Component.translatable((String)"block.databank.megastructure_save.saved", (Object[])new Object[]{this.uuid.toString()}));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void save() {
        Megastructure megastructure = Megastructure.createFromWorld(this.level, this.corner1, this.corner2, this.center);
        try {
            Path path = ((ServerLevel)this.level).getServer().getWorldPath(LevelResource.GENERATED_DIR).normalize();
            path = path.resolve("databank").resolve("megastructures");
            path = FileUtil.createPathToResource((Path)path, (String)this.getUuid().toString(), (String)".json");
            JsonElement json = Megastructure.CODEC.encode((Object)megastructure, (DynamicOps)JsonOps.INSTANCE, JsonOps.INSTANCE.mapBuilder()).build((Object)JsonOps.INSTANCE.empty()).result().orElse(null);
            if (json != null) {
                Path parentPath = path.getParent();
                Files.createDirectories(Files.exists(parentPath, new LinkOption[0]) ? parentPath.toRealPath(new LinkOption[0]) : parentPath, new FileAttribute[0]);
                Files.deleteIfExists(path);
                Files.writeString(path, (CharSequence)json.toString(), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            Databank.LOGGER.trace(e.getMessage(), e.fillInStackTrace());
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().isClientSide() && !event.getLevel().getBlockState(event.getPos()).is(BlockRegistry.MEGASTRUCTURE_SAVE.get())) {
            ((Optional)event.getEntity().getData(AttachmentTypeRegistry.BINDING_BLOCK)).ifPresent(binding -> {
                MegastructureSaveBlockEntity ent;
                if (binding instanceof MegastructureSaveBlockEntity && !(ent = (MegastructureSaveBlockEntity)((Object)binding)).isChangingBind()) {
                    if (ent.getBindProcess() == 1) {
                        ent.corner1 = event.getPos();
                        event.getEntity().sendSystemMessage((Component)Component.translatable((String)"block.databank.megastructure_save.corner2"));
                        ent.updateBlock();
                        ent.setBindProcess(2);
                    } else if (ent.getBindProcess() == 2) {
                        ent.corner2 = event.getPos();
                        event.getEntity().sendSystemMessage((Component)Component.translatable((String)"block.databank.megastructure_save.center", (Object[])new Object[]{ent.corner1.toShortString(), ent.corner2.toShortString()}));
                        ent.updateBlock();
                        ent.setBindProcess(3);
                    } else if (ent.getBindProcess() == 3) {
                        ent.center = event.getPos();
                        event.getEntity().setData(AttachmentTypeRegistry.BINDING_BLOCK, Optional.empty());
                        event.getEntity().sendSystemMessage((Component)Component.translatable((String)"block.databank.megastructure_save.finished", (Object[])new Object[]{ent.corner1.toShortString(), ent.corner2.toShortString()}));
                        ent.updateBlock();
                        ent.setBindProcess(0);
                    }
                }
            });
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putUUID("uuid", this.getUuid());
        if (this.corner1 != null) {
            tag.putInt("corner1X", this.corner1.getX());
            tag.putInt("corner1Y", this.corner1.getY());
            tag.putInt("corner1Z", this.corner1.getZ());
        }
        if (this.corner2 != null) {
            tag.putInt("corner2X", this.corner2.getX());
            tag.putInt("corner2Y", this.corner2.getY());
            tag.putInt("corner2Z", this.corner2.getZ());
        }
        if (this.center != null) {
            tag.putInt("centerX", this.center.getX());
            tag.putInt("centerY", this.center.getY());
            tag.putInt("centerZ", this.center.getZ());
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("uuid")) {
            this.uuid = tag.getUUID("uuid");
        }
        if (tag.contains("corner1X") && tag.contains("corner1Y") && tag.contains("corner1Z")) {
            this.corner1 = new BlockPos(tag.getInt("corner1X"), tag.getInt("corner1Y"), tag.getInt("corner1Z"));
        }
        if (tag.contains("corner2X") && tag.contains("corner2Y") && tag.contains("corner2Z")) {
            this.corner2 = new BlockPos(tag.getInt("corner2X"), tag.getInt("corner2Y"), tag.getInt("corner2Z"));
        }
        if (tag.contains("centerX") && tag.contains("centerY") && tag.contains("centerZ")) {
            this.center = new BlockPos(tag.getInt("centerX"), tag.getInt("centerY"), tag.getInt("centerZ"));
        }
    }
}

