/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.types;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.config.DatabankClientConfig;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.mixin.client.ItemColorsAccessor;
import com.cmdpro.databank.registry.HiddenTypeRegistry;
import com.cmdpro.databank.rendering.ShaderHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ItemHiddenType
extends HiddenTypeInstance.HiddenType<ItemHiddenTypeInstance> {
    public static final ItemHiddenType INSTANCE = new ItemHiddenType();
    public static final MapCodec<ItemHiddenTypeInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ITEM).fieldOf("original").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), i -> (ResourceKey)BuiltInRegistries.ITEM.getResourceKey(i).orElseThrow()).forGetter(type -> type.original), (App)ResourceKey.codec((ResourceKey)Registries.ITEM).fieldOf("hidden_as").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), i -> (ResourceKey)BuiltInRegistries.ITEM.getResourceKey(i).orElseThrow()).forGetter(type -> type.hiddenAs), (App)ComponentSerialization.CODEC.optionalFieldOf("name_override").forGetter(type -> type.nameOverride)).apply((Applicative)instance, ItemHiddenTypeInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemHiddenTypeInstance> STREAM_CODEC = StreamCodec.of((buf, val) -> {
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)val.original).orElseThrow());
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)val.hiddenAs).orElseThrow());
        buf.writeOptional(val.nameOverride, (buf2, val2) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), val2));
    }, buf -> {
        ResourceKey originalKey = buf.readResourceKey(Registries.ITEM);
        ResourceKey hiddenAsKey = buf.readResourceKey(Registries.ITEM);
        Item original = (Item)BuiltInRegistries.ITEM.get(originalKey);
        Item hiddenAs = (Item)BuiltInRegistries.ITEM.get(hiddenAsKey);
        Optional nameOverride = buf.readOptional(buf2 -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        return new ItemHiddenTypeInstance(original, hiddenAs, nameOverride);
    });
    private static HashMap<Item, Hidden> cache = new HashMap();

    @Override
    public MapCodec<ItemHiddenTypeInstance> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemHiddenTypeInstance> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void updateClient() {
        cache.clear();
    }

    @Override
    public void onRecieveClient() {
        ClientHandler.updateItemColors();
    }

    public static boolean isVisible(Item item, Player player) {
        if (player.level().isClientSide) {
            return ItemHiddenType.isVisibleClient(item);
        }
        return ItemHiddenType.getHiddenItem(item, player) == null;
    }

    public static boolean isVisibleClient(Item item) {
        return ItemHiddenType.getHiddenItemClient(item) == null;
    }

    public static Item getHiddenItem(Item item, Player player) {
        if (player.level().isClientSide) {
            return ItemHiddenType.getHiddenItemClient(item);
        }
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null) continue;
            if (type.isHidden(item, player)) {
                return type.hiddenAs;
            }
            if (!type.matches(item)) continue;
            break;
        }
        return null;
    }

    public static Item getHiddenItem(Item item) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null || !type.matches(item)) continue;
            return type.hiddenAs;
        }
        return null;
    }

    public static Optional<Component> getHiddenItemNameOverride(Item item) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || !type.matches(item)) continue;
            return type.nameOverride;
        }
        return Optional.empty();
    }

    public static Item getHiddenItemClient(Item item) {
        ItemHiddenTypeInstance type;
        HiddenTypeInstance<?> hiddenTypeInstance;
        Hidden hidden = cache.get(item);
        if (!cache.containsKey(item)) {
            for (Map.Entry<ResourceLocation, Hidden> i : new HashMap<ResourceLocation, Hidden>(HiddenManager.hidden).entrySet()) {
                HiddenTypeInstance<?> hiddenTypeInstance2 = i.getValue().type;
                if (!(hiddenTypeInstance2 instanceof ItemHiddenTypeInstance)) continue;
                ItemHiddenTypeInstance type2 = (ItemHiddenTypeInstance)hiddenTypeInstance2;
                if (type2.original == null || type2.hiddenAs == null || !type2.matches(item)) continue;
                hidden = i.getValue();
            }
            cache.put(item, hidden);
        }
        if (hidden != null && (hiddenTypeInstance = hidden.type) instanceof ItemHiddenTypeInstance && (type = (ItemHiddenTypeInstance)hiddenTypeInstance).isHiddenClient(item)) {
            return type.hiddenAs;
        }
        return null;
    }

    private static class ClientHandler {
        static HashMap<Item, ItemColor> overriden = new HashMap();

        private ClientHandler() {
        }

        public static void updateItemColors() {
            if (!ShaderHelper.isSodiumOrSimilarActive() && !DatabankClientConfig.forceAlternateHiddenColors) {
                return;
            }
            ItemColors colors = Minecraft.getInstance().getItemColors();
            HashMap<Item, ItemHiddenTypeInstance> wrappingData = new HashMap<Item, ItemHiddenTypeInstance>();
            for (Hidden i : HiddenTypeRegistry.ITEM.get().getHiddenOfType().values()) {
                ItemColor color;
                HiddenTypeInstance<?> hiddenTypeInstance = i.type;
                if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
                ItemHiddenTypeInstance itemHiddenTypeInstance = (ItemHiddenTypeInstance)hiddenTypeInstance;
                Item item = itemHiddenTypeInstance.original;
                wrappingData.put(item, itemHiddenTypeInstance);
                if (overriden.containsKey(item) || (color = ((ItemColorsAccessor)colors).getItemColors().get(item)) == null) continue;
                overriden.put(item, color);
            }
            ArrayList<Item> itemsNotWrapped = new ArrayList<Item>(overriden.keySet());
            for (Map.Entry entry : wrappingData.entrySet()) {
                ItemColor original = overriden.get(entry.getKey());
                ItemColor wrapped = ClientHandler.createWrapped(original, (ItemHiddenTypeInstance)entry.getValue());
                ((ItemColorsAccessor)colors).getItemColors().remove(entry.getKey());
                colors.register(wrapped, new ItemLike[]{(ItemLike)entry.getKey()});
            }
            for (Item item : itemsNotWrapped) {
                ((ItemColorsAccessor)colors).getItemColors().remove(item);
                colors.register(overriden.get(item), new ItemLike[]{item});
                overriden.remove(item);
            }
        }

        public static ItemColor createWrapped(ItemColor original, ItemHiddenTypeInstance instance) {
            ItemColors colors = Minecraft.getInstance().getItemColors();
            ItemColor wrapped = (stack, tintIndex) -> {
                Item hiddenAs;
                if (instance != null && instance.isHiddenClient(instance.original) && (hiddenAs = instance.hiddenAs) != instance.original) {
                    return colors.getColor(DatabankUtils.changeItemType(stack, hiddenAs), tintIndex);
                }
                if (original != null) {
                    return original.getColor(stack, tintIndex);
                }
                return -1;
            };
            return wrapped;
        }
    }

    public static class ItemHiddenTypeInstance
    extends HiddenTypeInstance<Item> {
        public Item original;
        public Item hiddenAs;
        public Optional<Component> nameOverride;

        public ItemHiddenTypeInstance(Item original, Item hiddenAs, Optional<Component> nameOverride) {
            this.original = original;
            this.hiddenAs = hiddenAs;
            this.nameOverride = nameOverride;
        }

        @Override
        public boolean matches(Item obj) {
            return obj.equals(this.original);
        }

        @Override
        public HiddenTypeInstance.HiddenType<? extends HiddenTypeInstance<Item>> getType() {
            return INSTANCE;
        }
    }
}

