/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden;

import com.cmdpro.databank.hidden.ClientHidden;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class HiddenTypeInstance<T> {
    public Hidden hidden;

    public boolean isHidden(T obj, Player player) {
        if (this.matches(obj)) {
            return !this.hidden.condition.isUnlocked(player);
        }
        return false;
    }

    public boolean isHiddenClient(T obj) {
        if (this.matches(obj)) {
            return !ClientHidden.unlocked.contains(this.hidden.id);
        }
        return false;
    }

    public abstract boolean matches(T var1);

    public abstract HiddenType getType();

    public static abstract class HiddenType<T extends HiddenTypeInstance<?>> {
        public abstract MapCodec<T> codec();

        public abstract StreamCodec<RegistryFriendlyByteBuf, T> streamCodec();

        public abstract void updateClient();

        public void onRecieveClient() {
        }

        public HashMap<ResourceLocation, Hidden> getHiddenOfType() {
            HashMap<ResourceLocation, Hidden> hiddens = new HashMap<ResourceLocation, Hidden>();
            HiddenManager.hidden.forEach((k, v) -> {
                if (this.equals(v.type.getType())) {
                    hiddens.put((ResourceLocation)k, (Hidden)v);
                }
            });
            return hiddens;
        }
    }
}

