/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.data;

import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.data.ModData;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.items.tools.ItemArmor;
import de.ellpeck.naturesaura.items.tools.ItemAxe;
import de.ellpeck.naturesaura.items.tools.ItemHoe;
import de.ellpeck.naturesaura.items.tools.ItemPickaxe;
import de.ellpeck.naturesaura.items.tools.ItemShovel;
import de.ellpeck.naturesaura.items.tools.ItemSword;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagProvider
extends ItemTagsProvider {
    public ItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider, "naturesaura", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.copy(BlockTags.LOGS, ItemTags.LOGS);
        this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
        this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
        this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
        this.copy(BlockTags.RAILS, ItemTags.RAILS);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.tag((TagKey<Item>)Tags.Items.RODS_WOODEN).add((Object)ModItems.ANCIENT_STICK);
        this.tag((TagKey<Item>)Tags.Items.INGOTS).add((Object[])new Item[]{ModItems.DEPTH_INGOT, ModItems.SKY_INGOT, ModItems.INFUSED_IRON});
        ModData.getAllModItems().filter(i -> i instanceof Item).map(i -> (Item)i).forEach(i -> {
            if (i instanceof ItemPickaxe) {
                this.tag((TagKey<Item>)ItemTags.CLUSTER_MAX_HARVESTABLES).add(i);
                this.tag((TagKey<Item>)ItemTags.PICKAXES).add(i);
            } else if (i instanceof ItemAxe) {
                this.tag((TagKey<Item>)ItemTags.AXES).add(i);
            } else if (i instanceof ItemHoe) {
                this.tag((TagKey<Item>)ItemTags.HOES).add(i);
            } else if (i instanceof ItemSword) {
                this.tag((TagKey<Item>)ItemTags.SWORDS).add(i);
            } else if (i instanceof ItemShovel) {
                this.tag((TagKey<Item>)ItemTags.SHOVELS).add(i);
            } else if (i instanceof ItemArmor) {
                TagKey tag;
                ItemArmor a = (ItemArmor)i;
                switch (a.getType()) {
                    case HELMET: {
                        TagKey tagKey = ItemTags.HEAD_ARMOR;
                        break;
                    }
                    case CHESTPLATE: {
                        TagKey tagKey = ItemTags.CHEST_ARMOR;
                        break;
                    }
                    case LEGGINGS: {
                        TagKey tagKey = ItemTags.LEG_ARMOR;
                        break;
                    }
                    case BOOTS: {
                        TagKey tagKey = ItemTags.FOOT_ARMOR;
                        break;
                    }
                    default: {
                        TagKey tagKey = tag = null;
                    }
                }
                if (tag != null) {
                    this.tag((TagKey<Item>)tag).add(i);
                }
            }
        });
        Compat.addItemTags(this);
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(TagKey<Item> tag) {
        return super.tag(tag);
    }
}

