/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderUtils {
    public static final ResourceLocation WHITE = ResourceLocation.fromNamespaceAndPath((String)"relicsofrain", (String)"textures/white.png");
    public static final BiFunction<ResourceLocation, VertexFormat.Mode, RenderType> TYPE = Util.memoize((rl, mode) -> RenderType.create((String)"relicsofrain_icosahedron", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)mode, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.ADDITIVE_TRANSPARENCY).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setOutputState(RenderStateShard.MAIN_TARGET).setColorLogicState(RenderStateShard.NO_COLOR_LOGIC).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).createCompositeState(false)));
    public static final Function<ResourceLocation, RenderType> SHROOM = Util.memoize(rl -> RenderType.create((String)"relicsofrain_shroom", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.ADDITIVE_TRANSPARENCY).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setOutputState(RenderStateShard.MAIN_TARGET).setColorLogicState(RenderStateShard.NO_COLOR_LOGIC).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).createCompositeState(false)));
    public static final List<Vector3f> icosahedronVertices = List.of(new Vector3f(0.8506508f, 0.5257311f, 0.0f), new Vector3f(1.01405476E-7f, 0.8506507f, -0.525731f), new Vector3f(1.01405476E-7f, 0.8506506f, 0.525731f), new Vector3f(0.5257309f, -6.267203E-8f, -0.85065067f), new Vector3f(0.52573115f, -6.267203E-8f, 0.85065067f), new Vector3f(0.8506508f, -0.5257311f, 0.0f), new Vector3f(-0.52573115f, 6.267203E-8f, -0.85065067f), new Vector3f(-0.8506508f, 0.5257311f, 0.0f), new Vector3f(-0.5257309f, 6.267203E-8f, 0.85065067f), new Vector3f(-1.01405476E-7f, -0.8506506f, -0.525731f), new Vector3f(-1.01405476E-7f, -0.8506507f, 0.525731f), new Vector3f(-0.8506508f, -0.5257311f, 0.0f));
    public static final int[] icosahedronTriangleIndicies = new int[]{0, 1, 2, 0, 3, 1, 0, 2, 4, 3, 0, 5, 0, 4, 5, 1, 3, 6, 1, 7, 2, 7, 1, 6, 4, 2, 8, 7, 8, 2, 9, 3, 5, 6, 3, 9, 5, 4, 10, 4, 8, 10, 9, 5, 10, 7, 6, 11, 7, 11, 8, 11, 6, 9, 8, 11, 10, 10, 11, 9};

    public static RenderType getIcosahedronType(ResourceLocation rl) {
        return RenderUtils.getIcosahedronType(rl, VertexFormat.Mode.TRIANGLES);
    }

    public static RenderType getIcosahedronType(ResourceLocation rl, VertexFormat.Mode mode) {
        return TYPE.apply(rl, mode);
    }

    public static RenderType getShroomType(ResourceLocation rl) {
        return SHROOM.apply(rl);
    }

    public static Vector3f calculateNormal(Vector3f v1, Vector3f v2, Vector3f v3) {
        Vector3f edge1 = new Vector3f((Vector3fc)v2);
        edge1.sub((Vector3fc)v1);
        Vector3f edge2 = new Vector3f((Vector3fc)v3);
        edge2.sub((Vector3fc)v1);
        Vector3f normal = new Vector3f((Vector3fc)edge1);
        normal.cross((Vector3fc)edge2);
        normal.normalize();
        return normal;
    }
}

