/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class DungeonFinder {
    public static BlockPos findNearestDungeon(ServerLevel level, BlockPos startPos, int searchRadius) {
        int chunkX = startPos.getX() >> 4;
        int chunkZ = startPos.getZ() >> 4;
        int dx = 0;
        while (dx <= searchRadius) {
            int dz = 0;
            while (dz <= searchRadius) {
                int currentChunkX = chunkX + dx;
                int currentChunkZ = chunkZ + dz;
                System.out.println(currentChunkX + "; " + currentChunkZ);
                LevelChunk chunk = level.getChunk(currentChunkX, currentChunkZ);
                BlockPos dungeonPos = DungeonFinder.findDungeonInChunk(level, (ChunkAccess)chunk);
                if (dungeonPos != null) {
                    return dungeonPos;
                }
                dz = dz > 0 ? dz * -1 : dz * -1 + 1;
            }
            dx = dx > 0 ? dx * -1 : dx * -1 + 1;
        }
        return null;
    }

    private static BlockPos findDungeonInChunk(ServerLevel level, ChunkAccess chunk) {
        for (BlockPos pos : chunk.getBlockEntitiesPos()) {
            if (!DungeonFinder.isDungeon(level, pos)) continue;
            return pos;
        }
        return null;
    }

    private static boolean isDungeon(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() instanceof SpawnerBlock;
    }
}

