/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.Random;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.registry.DataComponentRegistry;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.registry.RarityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class UnlabeledSyringeItem
extends AbstractRORItem {
    public UnlabeledSyringeItem(Item.Properties props) {
        super(new Item.Properties().rarity((Rarity)RarityRegistry.LUNAR_RARITY.getValue()).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().leveling(LevelingData.builder().maxLevel(1).initialCost(100).step(100).build()).abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"mutation").maxLevel(1).stat(StatData.builder((String)"curio_amount").initialValue(1.0, 1.0).formatValue(Math::round).upgradeModifier(UpgradeOperation.ADD, 1.0).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(2001741784).endColor(14684258).build()).tooltip(TooltipData.builder().borderTop(-5597713).borderBottom(-2830097).build()).build()).build();
    }

    @Nullable
    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        String take = (String)stack.getOrDefault(DataComponentRegistry.CURIO_TAKE, (Object)"");
        String give = (String)stack.getOrDefault(DataComponentRegistry.CURIO_GIVE, (Object)"");
        if (take.isEmpty() || give.isEmpty()) {
            return super.getSlotModifiers(stack);
        }
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return super.getSlotModifiers(stack);
        }
        IRelicItem relic = (IRelicItem)item;
        return RelicSlotModifier.builder().modifier(take, -1).modifier(give, (int)relic.getStatValue(stack, "mutation", "curio_amount")).build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        int feet = UnlabeledSyringeItem.getSlots(livingEntity, "feet");
        int hands = UnlabeledSyringeItem.getSlots(livingEntity, "hands");
        int head = UnlabeledSyringeItem.getSlots(livingEntity, "head");
        if (feet != -1) {
            if (feet == 0) {
                slotContext.entity().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 0, true, false, false));
            } else if (feet > 2) {
                slotContext.entity().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 10, feet - 3, true, false, false));
            }
        }
        if (hands != -1) {
            if (hands == 0) {
                slotContext.entity().addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 10, 0, true, false, false));
            } else if (hands > 2) {
                slotContext.entity().addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 10, hands - 3, true, false, false));
            }
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        if (!stack.has(DataComponentRegistry.CURIO_GIVE) && !slotContext.entity().level().isClientSide) {
            ArrayList slots = Lists.newArrayList((Object[])new String[]{"head", "feet", "hands"});
            String take = (String)slots.remove(new Random().nextInt(slots.size()));
            String give = (String)slots.remove(new Random().nextInt(slots.size()));
            stack.set(DataComponentRegistry.CURIO_TAKE, (Object)take);
            stack.set(DataComponentRegistry.CURIO_GIVE, (Object)give);
        }
        if (CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).isEmpty() || ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).get()).getCurios().isEmpty()) {
            return true;
        }
        return UnlabeledSyringeItem.getSlots(slotContext.entity(), (String)stack.get(DataComponentRegistry.CURIO_TAKE)) >= 1;
    }

    public static int getSlots(LivingEntity living, String slot) {
        if (!CuriosApi.getEntitySlots((LivingEntity)living).containsKey(slot) || CuriosApi.getCuriosInventory((LivingEntity)living).isEmpty() || ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)living).get()).getCurios().isEmpty()) {
            return -1;
        }
        return ((ICurioStacksHandler)((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)living).get()).getCurios().get(slot)).getSlots();
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void renderPlayer(RenderPlayerEvent.Pre e) {
            if (!(EntityUtils.findEquippedCurio((Entity)e.getEntity(), (Item)((Item)ItemRegistry.UNLABELED_SYRINGE.get())).getItem() instanceof IRelicItem)) {
                return;
            }
            PlayerModel model = (PlayerModel)e.getRenderer().getModel();
            if (UnlabeledSyringeItem.getSlots((LivingEntity)e.getEntity(), "head") == 0) {
                model.head.visible = false;
                model.hat.visible = false;
            }
            if (UnlabeledSyringeItem.getSlots((LivingEntity)e.getEntity(), "hands") == 1) {
                model.leftArm.visible = false;
                model.leftSleeve.visible = false;
            } else if (UnlabeledSyringeItem.getSlots((LivingEntity)e.getEntity(), "hands") == 0) {
                model.leftArm.visible = false;
                model.leftSleeve.visible = false;
                model.rightArm.visible = false;
                model.rightSleeve.visible = false;
            }
            if (UnlabeledSyringeItem.getSlots((LivingEntity)e.getEntity(), "feet") == 1) {
                model.leftLeg.visible = false;
                model.leftPants.visible = false;
            } else if (UnlabeledSyringeItem.getSlots((LivingEntity)e.getEntity(), "feet") == 0) {
                model.leftLeg.visible = false;
                model.leftPants.visible = false;
                model.rightLeg.visible = false;
                model.rightPants.visible = false;
                e.getPoseStack().translate(0.0, model.crouching ? -0.5 : -0.7, 0.0);
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderArmEvent e) {
            if (!(EntityUtils.findEquippedCurio((Entity)Minecraft.getInstance().player, (Item)((Item)ItemRegistry.UNLABELED_SYRINGE.get())).getItem() instanceof IRelicItem)) {
                return;
            }
            if (UnlabeledSyringeItem.getSlots((LivingEntity)Minecraft.getInstance().player, "hands") == 0) {
                e.setCanceled(true);
            }
        }
    }
}

