/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import meow.binary.relicsofrain.api.IProcCoefficient;
import meow.binary.relicsofrain.api.ItemDamageSource;
import meow.binary.relicsofrain.api.effect.OnHitEffect;
import meow.binary.relicsofrain.entity.projectile.LightningArc;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.registry.EntityRegistry;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.registry.RarityRegistry;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class UkuleleItem
extends AbstractRORItem
implements IRenderableCurio,
OnHitEffect,
IProcCoefficient {
    public static final int PROC_COOLDOWN = 40;

    public UkuleleItem(Item.Properties props) {
        super(new Item.Properties().rarity((Rarity)RarityRegistry.UNCOMMON_RARITY.getValue()).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"lightning_chain").stat(StatData.builder((String)"proc_chance").initialValue(0.15, 0.18).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.175).thresholdValue(0.0, 1.0).formatValue(value -> (int)Math.round(value * 100.0)).build()).stat(StatData.builder((String)"max_targets").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.ADD, 1.5).formatValue(Math::round).build()).stat(StatData.builder((String)"max_distance").initialValue(4.0, 7.0).upgradeModifier(UpgradeOperation.ADD, 0.65).formatValue(Math::round).build()).stat(StatData.builder((String)"damage_percentage").initialValue(0.25, 0.5).upgradeModifier(UpgradeOperation.ADD, 0.05).thresholdValue(0.0, 1.0).formatValue(value -> (int)Math.round(value * 100.0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(175).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"lightning_chain").gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().build()).tooltip(TooltipData.builder().borderBottom(-11854058).borderTop(-6924480).build()).build()).build();
    }

    @Override
    public float getProcCoefficient() {
        return 0.2f;
    }

    @Override
    public int onHit(LivingDamageEvent.Post e) {
        ItemDamageSource proc;
        int exitValue = OnHitEffect.super.onHit(e);
        if (exitValue != 1) {
            return exitValue;
        }
        Entity causingEntity = e.getSource().getEntity();
        Entity source = e.getSource().getDirectEntity();
        LivingEntity target = e.getEntity();
        if (EntityUtils.isAlliedTo((Entity)causingEntity, (Entity)target)) {
            return -1;
        }
        DamageSource damageSource = e.getSource();
        if (damageSource instanceof ItemDamageSource && (proc = (ItemDamageSource)damageSource).getItemUsed().getItem() instanceof UkuleleItem) {
            return -1;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)causingEntity, (Item)((Item)ItemRegistry.UKULELE.get()));
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return -1;
        }
        IRelicItem relic = (IRelicItem)item;
        if ((double)target.level().random.nextFloat() > relic.getStatValue(stack, "lightning_chain", "proc_chance")) {
            return 0;
        }
        LightningArc arc = new LightningArc((EntityType<? extends LightningArc>)((EntityType)EntityRegistry.LIGHTNING_ARC.get()), target.level());
        arc.setOwner(causingEntity);
        arc.setDamage(relic.getStatValue(stack, "lightning_chain", "damage_percentage") * (double)e.getOriginalDamage());
        arc.setMaxDistance(relic.getStatValue(stack, "lightning_chain", "max_distance"));
        arc.setTarget(target);
        arc.getBouncedTargets().add(target.getStringUUID());
        arc.setTargetsLeft((int)relic.getStatValue(stack, "lightning_chain", "max_targets"));
        arc.setPos(target.getEyePosition());
        arc.setItemStack(stack);
        target.level().addFreshEntity((Entity)arc);
        return 1;
    }

    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -0.5f, 6.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-4.0f, 1.0f, 0.495f, 8.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 0).addBox(-1.0f, -11.0f, 1.5f, 2.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)3.505f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        body.addOrReplaceChild("cube_5_r1", CubeListBuilder.create().texOffs(20, 14).addBox(-0.995f, -2.85f, 0.0f, 1.99f, 2.85f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.6173f, (float)0.4239f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("cube_5_r2", CubeListBuilder.create().texOffs(20, 18).addBox(-2.5f, -3.5f, -0.5f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 9).addBox(-1.5f, -4.0f, -1.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)2.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        LivingEntity entity = slotContext.entity();
        matrixStack.pushPose();
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

