/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.registry.ItemRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class SoldierSyringeItem
extends AbstractRORItem {
    public SoldierSyringeItem(Item.Properties props) {
        super(new Item.Properties().rarity(Rarity.COMMON).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"attack_speed").maxLevel(20).stat(StatData.builder((String)"attack_speed").initialValue(0.075, 0.15).upgradeModifier(UpgradeOperation.ADD, 0.075).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).leveling(LevelingData.builder().maxLevel(20).initialCost(100).step(150).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"attack_speed").gem(GemShape.SQUARE, GemColor.YELLOW).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-16092963).endColor(8258).build()).build()).build();
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (!(stack.getItem() instanceof SoldierSyringeItem)) {
            return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        }
        if (!(interactionTarget instanceof Zombie)) {
            return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        }
        Zombie zombie = (Zombie)interactionTarget;
        player.setItemInHand(usedHand, new ItemStack((ItemLike)ItemRegistry.UNLABELED_SYRINGE.get()));
        player.level().playSound(null, player.blockPosition(), SoundEvents.VEX_HURT, SoundSource.HOSTILE, 1.0f, 1.0f);
        zombie.invulnerableTime = 0;
        zombie.hurt(zombie.level().damageSources().playerAttack(player), 10.0f);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.ATTACK_SPEED, (float)this.getStatValue(stack, "attack_speed", "attack_speed"), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).build();
    }

    @SubscribeEvent
    public static void damage(LivingIncomingDamageEvent e) {
        if (e.getEntity().level().isClientSide) {
            return;
        }
        Entity entity = e.getSource().getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)livingEntity, (Item)((Item)ItemRegistry.SOLDIER_SYRINGE.get()));
        Item item = stack.getItem();
        if (!(item instanceof SoldierSyringeItem)) {
            return;
        }
        SoldierSyringeItem relic = (SoldierSyringeItem)item;
        if (e.getAmount() >= 1.0f) {
            relic.spreadRelicExperience(livingEntity, stack, 1);
        }
    }

    @SubscribeEvent
    public static void convertSyringe(LivingIncomingDamageEvent e) {
        if (e.getEntity().level().isClientSide) {
            return;
        }
        Entity entity = e.getSource().getDirectEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof SoldierSyringeItem)) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)livingEntity;
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ItemRegistry.UNLABELED_SYRINGE.get()));
        player.level().playSound(null, player.blockPosition(), SoundEvents.VEX_HURT, SoundSource.HOSTILE, 1.0f, 1.0f);
        zombie.invulnerableTime = 0;
        zombie.hurt(e.getSource(), 10.0f);
    }
}

