/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.registry.RarityRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class IrradiantPearlItem
extends AbstractRORItem {
    public IrradiantPearlItem(Item.Properties props) {
        super(new Item.Properties().rarity((Rarity)RarityRegistry.SPECIAL_RARITY.getValue()).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"1up").stat(StatData.builder((String)"attribute_modifier").initialValue(0.01, 0.02).upgradeModifier(UpgradeOperation.ADD, 0.018).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).maxLevel(10).build()).build()).leveling(LevelingData.builder().maxLevel(10).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-11021852).endColor(2424746).build()).build()).build();
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityTickEvent.Pre e) {
        LivingEntity livingEntity;
        block3: {
            block2: {
                Entity entity = e.getEntity();
                if (!(entity instanceof LivingEntity)) break block2;
                livingEntity = (LivingEntity)entity;
                if (!livingEntity.level().isClientSide) break block3;
            }
            return;
        }
        float multiplier = (float)EntityUtils.findEquippedCurios((Entity)livingEntity, (Item)((Item)ItemRegistry.IRRADIANT_PEARL.get())).stream().mapToDouble(stack -> {
            IrradiantPearlItem item = (IrradiantPearlItem)stack.getItem();
            return item.getStatValue((ItemStack)stack, "1up", "attribute_modifier");
        }).sum();
        RelicAttributeModifier modifiers = RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.ARMOR, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.ARMOR_TOUGHNESS, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.ATTACK_DAMAGE, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.ATTACK_KNOCKBACK, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.ATTACK_SPEED, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.BLOCK_BREAK_SPEED, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.BLOCK_INTERACTION_RANGE, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.ENTITY_INTERACTION_RANGE, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.FLYING_SPEED, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.JUMP_STRENGTH, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.KNOCKBACK_RESISTANCE, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.LUCK, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.MAX_ABSORPTION, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.MAX_HEALTH, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.MINING_EFFICIENCY, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.MOVEMENT_EFFICIENCY, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.OXYGEN_BONUS, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.SNEAKING_SPEED, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.MOVEMENT_SPEED, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.STEP_HEIGHT, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.SUBMERGED_MINING_SPEED, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.SWEEPING_DAMAGE_RATIO, multiplier)).attribute(new RelicAttributeModifier.Modifier(Attributes.SAFE_FALL_DISTANCE, multiplier * 1.5f)).attribute(new RelicAttributeModifier.Modifier(Attributes.WATER_MOVEMENT_EFFICIENCY, multiplier)).build();
        modifiers.getAttributes().forEach(modifier -> {
            AttributeInstance patt0$temp = livingEntity.getAttribute(modifier.getAttribute());
            if (!(patt0$temp instanceof AttributeInstance)) {
                return;
            }
            AttributeInstance attribute = patt0$temp;
            AttributeModifier attributeModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"relicsofrain", (String)modifier.getAttribute().getKey().location().getPath()), (double)modifier.getMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            if (multiplier == 0.0f) {
                attribute.removeModifier(attributeModifier.id());
            } else {
                attribute.addOrUpdateTransientModifier(attributeModifier);
            }
        });
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"tooltip.relicsofrain.irradiant_pearl.source").withStyle(ChatFormatting.GRAY));
        return list;
    }
}

