/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meow.binary.relicsofrain.api.IProcCoefficient;
import meow.binary.relicsofrain.api.ItemDamageSource;
import meow.binary.relicsofrain.api.effect.OnKillEffect;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.network.FrostRelicUpdatePacket;
import meow.binary.relicsofrain.registry.DataComponentRegistry;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.registry.RarityRegistry;
import meow.binary.relicsofrain.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class FrostRelicItem
extends AbstractRORItem
implements IRenderableCurio,
OnKillEffect,
IProcCoefficient {
    private static double STARTING_RADIUS = 4.0;
    public static Map<Integer, Float> lerpedRadius = new HashMap<Integer, Float>();

    public FrostRelicItem(Item.Properties props) {
        super(new Item.Properties().rarity((Rarity)RarityRegistry.LEGENDARY_RARITY.getValue()).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"ice_storm").stat(StatData.builder((String)"damage_percentage").initialValue(0.8, 1.2).upgradeModifier(UpgradeOperation.ADD, 0.26).formatValue(value -> (int)(Math.round(value * 100.0) * 4L)).build()).stat(StatData.builder((String)"max_radius").initialValue(6.0, 8.0).upgradeModifier(UpgradeOperation.ADD, 3.0).formatValue(Math::round).build()).maxLevel(5).build()).build()).leveling(LevelingData.builder().maxLevel(5).initialCost(250).step(175).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"ice_storm").gem(GemShape.SQUARE, GemColor.BLUE).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(1997107663).endColor(8647152).build()).tooltip(TooltipData.builder().borderBottom(-16158257).borderTop(-8130064).build()).build()).build();
    }

    @Override
    public float getProcCoefficient() {
        return 0.2f;
    }

    public double getCurrentRadius(List<Integer> timers, double maxRadius) {
        return Math.min(!timers.isEmpty() ? STARTING_RADIUS + (double)((timers.size() - 1) * 2) : 0.0, maxRadius);
    }

    public List<LivingEntity> findEligibleEntities(LivingEntity entity, double radius) {
        return entity.level().getEntitiesOfClass(LivingEntity.class, new AABB(entity.position(), entity.position()).inflate(radius), e -> !EntityUtils.isAlliedTo((Entity)entity, (Entity)e) && e.isAlive() && entity.position().distanceTo(e.position()) <= radius);
    }

    @Override
    public int onKill(LivingDeathEvent e) {
        LivingEntity living;
        int exitValue = OnKillEffect.super.onKill(e);
        if (exitValue != 1) {
            return exitValue;
        }
        Entity causingEntity = e.getSource().getEntity();
        Entity source = e.getSource().getDirectEntity();
        LivingEntity target = e.getEntity();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)causingEntity, (Item)((Item)ItemRegistry.FROST_RELIC.get()));
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return -1;
        }
        IRelicItem relic = (IRelicItem)item;
        ArrayList timers = Lists.newArrayList((Iterable)((Iterable)stack.getOrDefault(DataComponentRegistry.TIMER_LIST, new ArrayList())));
        double maxRadius = relic.getStatValue(stack, "ice_storm", "max_radius");
        if (this.getCurrentRadius(timers, maxRadius) < maxRadius) {
            timers.add(120);
        } else {
            timers.set(0, 120);
        }
        relic.spreadRelicExperience(causingEntity instanceof LivingEntity ? (living = (LivingEntity)causingEntity) : null, stack, 1);
        stack.set(DataComponentRegistry.TIMER_LIST, (Object)timers);
        if (causingEntity != null) {
            NetworkHandler.sendToClientsTrackingEntityAndSelf((CustomPacketPayload)new FrostRelicUpdatePacket(causingEntity.getId()), (Entity)causingEntity);
        }
        return 1;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        ArrayList timers = Lists.newArrayList((Iterable)((Iterable)stack.getOrDefault(DataComponentRegistry.TIMER_LIST, new ArrayList())));
        if (slotContext.entity().level().isClientSide || slotContext.entity().level().tickRateManager().isFrozen()) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        double maxRadius = relic.getStatValue(stack, "ice_storm", "max_radius");
        double radius = this.getCurrentRadius(timers, maxRadius);
        if (radius > 0.0) {
            Vec3 pos = slotContext.entity().getEyePosition().add(radius * (double)Mth.sin((float)((float)slotContext.entity().tickCount / 16.0f)), 0.0, radius * (double)Mth.cos((float)((float)slotContext.entity().tickCount / 16.0f)));
            Vec3 pos2 = slotContext.entity().getEyePosition().subtract(radius * (double)Mth.sin((float)((float)slotContext.entity().tickCount / 16.0f)), 0.0, radius * (double)Mth.cos((float)((float)slotContext.entity().tickCount / 16.0f)));
            ((ServerLevel)slotContext.entity().level()).sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
            ((ServerLevel)slotContext.entity().level()).sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, pos2.x, pos2.y, pos2.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        timers.replaceAll(i -> i - 1);
        timers.removeIf(i -> i == 0);
        stack.set(DataComponentRegistry.TIMER_LIST, (Object)timers);
        if (slotContext.entity().tickCount % 5 == 0) {
            double baseDamage = slotContext.entity().getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            if (baseDamage == 0.0) {
                return;
            }
            List<LivingEntity> toHurt = this.findEligibleEntities(slotContext.entity(), radius);
            for (LivingEntity entity : toHurt) {
                entity.invulnerableTime = 0;
                if (!entity.hurt((DamageSource)ItemDamageSource.get((ResourceKey<DamageType>)DamageTypes.FREEZE, entity.level(), (Entity)slotContext.entity(), (Entity)slotContext.entity(), stack), (float)(baseDamage * relic.getStatValue(stack, "ice_storm", "damage_percentage")))) continue;
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 30, 1, false, true), (Entity)slotContext.entity());
                entity.invulnerableTime = 0;
            }
        }
    }

    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"left_leg"});
    }

    public LayerDefinition constructLayerDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 1).addBox(2.61f, 0.0f, -2.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        model.prepareMobModel(entity, limbSwing * 0.76f, limbSwingAmount / 4.0f, partialTicks);
        model.setupAnim(entity, limbSwing * 0.76f, limbSwingAmount / 4.0f, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.translate(0.0, -0.125, 0.0);
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    public static void renderIceStorm(PoseStack poseStack, LivingEntity livingEntity, ItemStack stack, float partialTicks) {
        int id = livingEntity.getId();
        Item item = stack.getItem();
        if (!(item instanceof FrostRelicItem)) {
            return;
        }
        FrostRelicItem relic = (FrostRelicItem)item;
        ArrayList timers = Lists.newArrayList((Iterable)((Iterable)stack.getOrDefault(DataComponentRegistry.TIMER_LIST, new ArrayList())));
        float maxRadius = (float)relic.getStatValue(stack, "ice_storm", "max_radius");
        float radius = (float)relic.getCurrentRadius(timers, maxRadius);
        float tickMultiple = Mth.clamp((float)(livingEntity.level().tickRateManager().tickrate() / 20.0f), (float)0.0f, (float)1.0f);
        lerpedRadius.put(id, Float.valueOf(Mth.lerp((float)Mth.clamp((float)(Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() / 4.0f * tickMultiple), (float)0.0f, (float)1.0f), (float)lerpedRadius.getOrDefault(id, Float.valueOf(0.0f)).floatValue(), (float)radius)));
        float r = lerpedRadius.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        float ii = Mth.clamp((float)(r - 0.15f), (float)0.0f, (float)1.35f) / 1.5f;
        if ((double)r < 0.025) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(r + ii * 0.5f, r + ii * 0.5f, r + ii * 0.5f);
        poseStack.mulPose(Axis.YP.rotation(r * 0.5f));
        poseStack.mulPose(Axis.YP.rotation(((float)livingEntity.tickCount + partialTicks) / 30.0f));
        RenderType type = RenderUtils.getIcosahedronType(RenderUtils.WHITE);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        for (int i = 0; i < RenderUtils.icosahedronTriangleIndicies.length; i += 3) {
            builder.addVertex(poseStack.last(), RenderUtils.icosahedronVertices.get(RenderUtils.icosahedronTriangleIndicies[i])).setColor(0, (int)(30.0f * ii), (int)(40.0f * ii), 255).setUv(0.0f, 0.0f).setLight(LightTexture.pack((int)15, (int)15));
            builder.addVertex(poseStack.last(), RenderUtils.icosahedronVertices.get(RenderUtils.icosahedronTriangleIndicies[i + 1])).setColor(0, (int)(10.0f * ii), (int)(40.0f * ii), 255).setUv(0.0f, 1.0f).setLight(LightTexture.pack((int)15, (int)15));
            builder.addVertex(poseStack.last(), RenderUtils.icosahedronVertices.get(RenderUtils.icosahedronTriangleIndicies[i + 2])).setColor(0, (int)(20.0f * ii), (int)(40.0f * ii), 255).setUv(1.0f, 1.0f).setLight(LightTexture.pack((int)15, (int)15));
        }
        MeshData mesh = builder.build();
        if (mesh != null) {
            type.draw(mesh);
        }
        poseStack.popPose();
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void renderLevel(RenderLevelStageEvent e) {
            if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            for (int id : lerpedRadius.keySet()) {
                Entity entity = e.getCamera().getEntity().level().getEntity(id);
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.FROST_RELIC.get()));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                Item item = stack.getItem();
                if (!(item instanceof IRelicItem)) continue;
                IRelicItem relic = (IRelicItem)item;
                PoseStack p = e.getPoseStack();
                Vec3 cp = e.getCamera().getPosition();
                float partialTick = e.getPartialTick().getGameTimeDeltaPartialTick(!Minecraft.getInstance().isPaused());
                Vec3 pp = livingEntity.getPosition(partialTick);
                p.pushPose();
                p.translate(pp.x - cp.x, pp.y - cp.y + (double)livingEntity.getBbHeight() / 2.0, pp.z - cp.z);
                FrostRelicItem.renderIceStorm(p, livingEntity, stack, partialTick);
                p.popPose();
            }
        }
    }
}

