/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import meow.binary.relicsofrain.item.AbstractRORItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class EnergyDrinkItem
extends AbstractRORItem {
    public EnergyDrinkItem(Item.Properties props) {
        super(new Item.Properties().rarity(Rarity.COMMON).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"speed_boost").maxLevel(20).stat(StatData.builder((String)"sprint_multiplier").initialValue(0.1875, 0.1918).upgradeModifier(UpgradeOperation.ADD, 0.09615).formatValue(value -> MathUtils.round((double)(value * 100.0 * (double)1.3f), (int)1) + 0.1).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(20).step(150).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"speed_boost").gem(GemShape.OVAL, GemColor.PURPLE).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-65281).endColor(255).build()).tooltip(TooltipData.builder().borderBottom(-10273056).borderTop(-5081096).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relicItem = (IRelicItem)item;
        AttributeInstance attr = slotContext.entity().getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr == null) {
            return;
        }
        attr.addOrUpdateTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"relicsofrain", (String)"sprint_bonus"), slotContext.entity().isSprinting() ? relicItem.getStatValue(stack, "speed_boost", "sprint_multiplier") : 0.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        if (slotContext.entity().isSprinting() && slotContext.entity().tickCount % 20 == 0) {
            relicItem.spreadRelicExperience(slotContext.entity(), stack, 1);
        }
    }
}

