/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import it.hurts.sskirillss.relics.init.CreativeTabRegistry;
import it.hurts.sskirillss.relics.items.misc.CreativeContentConstructor;
import it.hurts.sskirillss.relics.items.misc.ICreativeTabContent;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import java.util.List;
import java.util.function.Consumer;
import meow.binary.relicsofrain.api.ItemDamageSource;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.SimpleTier;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class CrowbarItem
extends SwordItem
implements IRelicItem,
ICreativeTabContent {
    public static final float ENTITY_HEALTH_THRESHOLD = 0.9f;

    public CrowbarItem(Item.Properties props) {
        super((Tier)new SimpleTier(Tiers.IRON.getIncorrectBlocksForDrops(), 640, Tiers.IRON.getSpeed(), Tiers.IRON.getAttackDamageBonus(), Tiers.IRON.getEnchantmentValue(), () -> ((Tiers)Tiers.IRON).getRepairIngredient()), new Item.Properties().rarity(Rarity.COMMON).stacksTo(1).attributes(SwordItem.createAttributes((Tier)Tiers.IRON, (int)4, (float)-2.6f)));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem() || slotChanged;
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"heavy_hitter").maxLevel(20).stat(StatData.builder((String)"bonus_damage_multiplier").initialValue(0.5, 1.0).formatValue(value -> Math.round(value * 100.0)).upgradeModifier(UpgradeOperation.ADD, 0.25).build()).build()).ability(AbilityData.builder((String)"pry_it_open").maxLevel(0).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"heavy_hitter").gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).maxLevel(20).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-1869574000).endColor(0xFFFFFF).build()).build()).build();
    }

    @SubscribeEvent
    public static void modifyDamage(LivingDamageEvent.Pre e) {
        Player player;
        Item item;
        LivingEntity source;
        ItemStack stack;
        LivingEntity target;
        block6: {
            block5: {
                Entity entity = e.getSource().getEntity();
                target = e.getEntity();
                ItemStack itemStack = entity != null ? (entity.getWeaponItem() != null ? entity.getWeaponItem() : ItemStack.EMPTY) : (stack = ItemStack.EMPTY);
                if (target.level().isClientSide || target.getHealth() / target.getMaxHealth() < 0.9f || e.getSource() instanceof ItemDamageSource || !(entity instanceof LivingEntity)) break block5;
                source = (LivingEntity)entity;
                item = stack.getItem();
                if (item instanceof CrowbarItem) break block6;
            }
            return;
        }
        CrowbarItem relic = (CrowbarItem)item;
        if (CrowbarItem.isBroken(stack)) {
            e.setNewDamage(1.0f);
            return;
        }
        e.setNewDamage(e.getNewDamage() * (1.0f + (float)relic.getStatValue(stack, "heavy_hitter", "bonus_damage_multiplier")));
        target.knockback(1.25, source.getX() - target.getX(), source.getZ() - target.getZ());
        target.level().playSound(null, (Entity)target, SoundEvents.ANVIL_LAND, SoundSource.NEUTRAL, 0.4f, 1.35f);
        if (source instanceof Player && (player = (Player)source).getAttackStrengthScale(0.0f) >= 0.95f) {
            relic.spreadRelicExperience(source, stack, 1);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (CrowbarItem.isBroken(stack)) {
            return 0;
        }
        int result = super.damageItem(stack, amount, entity, onBroken);
        return Math.min(result, 1);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.relicsofrain.crowbar.damage_tip", (Object[])new Object[]{Math.round(90.0f)}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.relicsofrain.crowbar.damage", (Object[])new Object[]{Math.round(this.getStatValue(stack, "heavy_hitter", "bonus_damage_multiplier") * 100.0)}).withStyle(ChatFormatting.DARK_GREEN));
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        entity.setGlowingTag(true);
        return super.onEntityItemUpdate(stack, entity);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (CrowbarItem.isBroken(stack)) {
            return 0.0f;
        }
        if (state.is(BlockTags.PLANKS)) {
            return 100.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(BlockTags.PLANKS) || super.isCorrectToolForDrops(stack, state);
    }

    public String getConfigRoute() {
        return "relicsofrain";
    }

    public void gatherCreativeTabContent(CreativeContentConstructor creativeContentConstructor) {
        creativeContentConstructor.entry((CreativeModeTab)CreativeTabRegistry.RELICS_TAB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, new ItemLike[]{this});
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.getDamageValue() >= stack.getMaxDamage() - 1;
    }
}

