/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import meow.binary.relicsofrain.client.model.ShroomModel;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.network.BustlingFungusUpdatePacket;
import meow.binary.relicsofrain.registry.DataComponentRegistry;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.SlotContext;

public class BustlingFungusItem
extends AbstractRORItem {
    public static final double RADIUS = 2.5;
    public static final int COOLDOWN = 30;
    public static Map<Integer, Float> lerpedRadius = new HashMap<Integer, Float>();

    public BustlingFungusItem(Item.Properties props) {
        super(new Item.Properties().rarity(Rarity.COMMON).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"healing").maxLevel(20).stat(StatData.builder((String)"heal_amount").initialValue((double)0.01f, (double)0.015f).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1) * 4.0).upgradeModifier(UpgradeOperation.ADD, 0.005).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-10946145).endColor(21318).build()).tooltip(TooltipData.builder().borderBottom(-16090516).borderTop(-7803256).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"healing").gem(GemShape.SQUARE, GemColor.GREEN).build()).build()).maxLevel(20).step(175).initialCost(230).build()).build();
    }

    public List<LivingEntity> findEligibleEntities(LivingEntity entity, double radius) {
        return entity.level().getEntitiesOfClass(LivingEntity.class, new AABB(entity.position(), entity.position()).inflate(radius), e -> EntityUtils.isAlliedTo((Entity)entity, (Entity)e) && e.isAlive() && e.getHealth() < e.getMaxHealth() && entity.position().distanceTo(e.position()) <= radius);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        boolean isMoving;
        int ticksImmobile = (Integer)stack.getOrDefault(DataComponentRegistry.TICKS_IMMOBILE, (Object)0);
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        boolean bl = isMoving = slotContext.entity().getKnownMovement().multiply(1.0, slotContext.entity().onGround() ? 0.0 : 1.0, 1.0).lengthSqr() > 5.0E-4;
        if (!isMoving) {
            if (ticksImmobile < 30) {
                stack.set(DataComponentRegistry.TICKS_IMMOBILE, (Object)Mth.clamp((int)(ticksImmobile + 1), (int)0, (int)30));
            }
        } else if (ticksImmobile > 0) {
            stack.set(DataComponentRegistry.TICKS_IMMOBILE, (Object)0);
        }
        if (slotContext.entity().tickCount % 5 != 0 || ticksImmobile < 30) {
            return;
        }
        NetworkHandler.sendToClientsTrackingEntityAndSelf((CustomPacketPayload)new BustlingFungusUpdatePacket(slotContext.entity().getId()), (Entity)slotContext.entity());
        List<LivingEntity> entities = this.findEligibleEntities(slotContext.entity(), 2.5);
        if (entities.isEmpty()) {
            return;
        }
        for (LivingEntity entity : entities) {
            float toHeal = (float)(relic.getStatValue(stack, "healing", "heal_amount") * (double)slotContext.entity().getMaxHealth());
            entity.heal(toHeal);
            relic.spreadRelicExperience(slotContext.entity(), stack, 1);
        }
    }

    public static float smoothWave(float time, float exponent, double period) {
        double normalizedSine = 0.5 * (1.0 + Math.sin(Math.PI * 2 * (double)time / period));
        double smoothWave = Math.pow(normalizedSine, exponent);
        return (float)smoothWave;
    }

    private static void renderFungi(PoseStack p, LivingEntity livingEntity, ItemStack stack, float partialTick) {
        int light = LightTexture.pack((int)15, (int)15);
        int id = livingEntity.getId();
        Item item = stack.getItem();
        if (!(item instanceof BustlingFungusItem)) {
            return;
        }
        BustlingFungusItem relic = (BustlingFungusItem)item;
        int ticksImmobile = (Integer)stack.getOrDefault(DataComponentRegistry.TICKS_IMMOBILE, (Object)0);
        float totalTime = ((float)livingEntity.tickCount + partialTick) / 20.0f;
        float radius = ticksImmobile >= 30 ? 2.5f : 0.0f;
        float tickMultiple = Mth.clamp((float)(livingEntity.level().tickRateManager().tickrate() / 20.0f), (float)0.0f, (float)1.0f);
        lerpedRadius.put(id, Float.valueOf(Mth.lerp((float)Mth.clamp((float)(Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() / 3.0f * tickMultiple), (float)0.0f, (float)1.0f), (float)lerpedRadius.getOrDefault(id, Float.valueOf(0.0f)).floatValue(), (float)radius)));
        float r = lerpedRadius.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        float ii = Mth.clamp((float)(r - 0.15f), (float)0.0f, (float)1.35f) / 1.5f;
        float l = 0.57735f;
        if (r < 0.025f) {
            return;
        }
        p.pushPose();
        p.mulPose(Axis.YP.rotationDegrees((float)livingEntity.tickCount + partialTick));
        p.scale(r, 1.0f, r);
        RenderType type = RenderUtils.getIcosahedronType(RenderUtils.WHITE, VertexFormat.Mode.QUADS);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderUtils.getShroomType(RenderUtils.WHITE));
        int color = FastColor.ARGB32.color((int)100, (int)((int)(150.0f * ii)), (int)((int)(255.0f * ii)), (int)((int)(110.0f * ii)));
        for (int i = 0; i < 6; ++i) {
            builder.addVertex(p.last(), new Vector3f(l, 0.0f, 1.0f)).setColor(color).setUv(0.0f, 0.0f).setLight(light);
            builder.addVertex(p.last(), new Vector3f(l, 0.1f, 1.0f)).setColor(color).setUv(0.0f, 0.0f).setLight(light);
            builder.addVertex(p.last(), new Vector3f(-l, 0.1f, 1.0f)).setColor(color).setUv(0.0f, 0.0f).setLight(light);
            builder.addVertex(p.last(), new Vector3f(-l, 0.0f, 1.0f)).setColor(color).setUv(0.0f, 0.0f).setLight(light);
            p.mulPose(Axis.YP.rotationDegrees(60.0f));
        }
        MeshData mesh = builder.build();
        if (mesh != null) {
            type.draw(mesh);
        }
        p.popPose();
        for (int i = 0; i < 7; ++i) {
            ShroomModel model = new ShroomModel();
            int seed = i * 157 + i;
            Random random = new Random(seed + livingEntity.hashCode());
            random.nextFloat();
            random.nextFloat();
            random.nextFloat();
            p.pushPose();
            p.translate((double)random.nextFloat(-1.75f, 1.75f), 1.49, (double)random.nextFloat(-1.75f, 1.75f));
            p.scale(-1.0f, -1.0f, 1.0f);
            p.mulPose(Axis.ZP.rotationDegrees(random.nextFloat(-10.0f, 10.0f)));
            p.mulPose(Axis.XP.rotationDegrees(random.nextFloat(-10.0f, 10.0f)));
            float scale = random.nextFloat(0.75f, 1.25f);
            p.scale(scale, 1.0f, scale);
            float popHeight = BustlingFungusItem.smoothWave(totalTime + (float)seed, random.nextFloat(8.0f, 13.0f), random.nextFloat(6.0f, 9.0f));
            float alpha = Mth.clamp((float)(1.0f - popHeight * 2.0f), (float)0.0f, (float)1.0f);
            int c = FastColor.ARGB32.color((int)100, (int)((int)(150.0f * ii * alpha)), (int)((int)(255.0f * ii * alpha)), (int)((int)(110.0f * ii * alpha)));
            p.scale(alpha, 1.0f, alpha);
            p.translate(0.0, (double)popHeight + 0.05, 0.0);
            model.renderToBuffer(p, buffer, light, OverlayTexture.NO_OVERLAY, c);
            p.popPose();
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void renderLevel(RenderLevelStageEvent e) {
            if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            for (int id : lerpedRadius.keySet()) {
                Entity entity = e.getCamera().getEntity().level().getEntity(id);
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.BUSTLING_FUNGUS.get()));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!(stack.getItem() instanceof IRelicItem)) continue;
                PoseStack p = e.getPoseStack();
                Vec3 cp = e.getCamera().getPosition();
                float partialTick = e.getPartialTick().getGameTimeDeltaPartialTick(true);
                Vec3 pp = livingEntity.getPosition(partialTick);
                p.pushPose();
                p.translate(pp.x - cp.x, pp.y - cp.y, pp.z - cp.z);
                BustlingFungusItem.renderFungi(p, livingEntity, stack, partialTick);
                p.popPose();
            }
        }
    }
}

