/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.item.relic;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.MagicMirrorItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import meow.binary.relicsofrain.api.ItemDamageSource;
import meow.binary.relicsofrain.item.AbstractRORItem;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.registry.KeyMappingRegistry;
import meow.binary.relicsofrain.registry.RarityRegistry;
import meow.binary.relicsofrain.util.DungeonFinder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import top.theillusivec4.curios.api.SlotContext;

public class BrokenMirrorItem
extends AbstractRORItem {
    public BrokenMirrorItem(Item.Properties props) {
        super(new Item.Properties().rarity((Rarity)RarityRegistry.LUNAR_RARITY.getValue()).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().leveling(LevelingData.builder().maxLevel(0).initialCost(0).step(0).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(0).endColor(0).build()).tooltip(TooltipData.builder().borderBottom(-9385010).borderTop(-16747134).build()).build()).build();
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!playerIn.getCooldowns().isOnCooldown(ItemRegistry.BROKEN_MIRROR.asItem()) && !worldIn.isClientSide()) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            ServerLevel serverLevel = (ServerLevel)serverPlayer.level();
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.pass((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel serverLevel = (ServerLevel)player.level();
            if (!player.isCreative()) {
                player.getCooldowns().addCooldown(stack.getItem(), 1200);
            }
            player.hurt((DamageSource)ItemDamageSource.get((ResourceKey<DamageType>)DamageTypes.MAGIC, (Level)serverLevel, null, null, stack), 3.0f);
            player.addEffect(new MobEffectInstance((Holder)EffectRegistry.BLEEDING, 110, 1, false, true, true));
            BlockPos blockPos = DungeonFinder.findNearestDungeon(serverLevel, player.blockPosition(), 10);
            if (blockPos == null) {
                return stack;
            }
            Vec3 pos = blockPos.getBottomCenter().add(1.0, 0.0, 0.0);
            player.teleportTo(pos.x, pos.y, pos.z);
            player.addEffect(new MobEffectInstance(MobEffects.UNLUCK, 36000, 1, true, false, false));
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity entity) {
        return 40;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void input(InputEvent.Key e) {
            if (FMLLoader.isProduction()) {
                return;
            }
            if (KeyMappingRegistry.FREEZE.consumeClick() && Minecraft.getInstance().player != null) {
                ClientPacketListener connection = Minecraft.getInstance().getConnection();
                if (connection == null) {
                    return;
                }
                connection.sendCommand("tick " + (Minecraft.getInstance().player.level().tickRateManager().isFrozen() ? "unfreeze" : "freeze"));
            }
        }

        @SubscribeEvent
        public static void onEntityTick(EntityTickEvent.Post e) {
            ItemEntity item;
            block8: {
                block7: {
                    Entity entity = e.getEntity();
                    if (!(entity instanceof ItemEntity)) break block7;
                    item = (ItemEntity)entity;
                    if (!e.getEntity().level().isClientSide && item.getItem().getItem() instanceof MagicMirrorItem) break block8;
                }
                return;
            }
            ServerLevel level = (ServerLevel)item.level();
            Vec3 p = item.position().add(0.0, (double)(item.getBbHeight() / 2.0f), 0.0);
            if (item.fallDistance >= 3.0f) {
                level.sendParticles((ParticleOptions)ParticleTypes.WHITE_ASH, p.x, p.y, p.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (item.fallDistance >= 8.0f) {
                level.sendParticles((ParticleOptions)ParticleTypes.FLAME, p.x, p.y, p.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (item.fallDistance >= 12.0f) {
                item.getPersistentData().putBoolean("AboutToBreak", true);
            }
            if (!item.onGround() || !item.getPersistentData().getBoolean("AboutToBreak")) {
                return;
            }
            item.level().playSound(null, (Entity)item, SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.LIGHT_BLUE_STAINED_GLASS.defaultBlockState()), p.x, p.y, p.z, 10, 0.1, 0.1, 0.1, 1.0);
            item.setItem(ItemRegistry.BROKEN_MIRROR.toStack());
            item.getPersistentData().remove("AboutToBreak");
        }
    }
}

