/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.entity.projectile;

import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CEntityTargetPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import meow.binary.relicsofrain.api.ItemDamageSource;
import meow.binary.relicsofrain.registry.DamageTypeRegistry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class LightningArc
extends ThrowableProjectile
implements ITargetableEntity {
    private double damage = 0.0;
    private double maxDistance = 0.0;
    private int targetsLeft = 1;
    @Nullable
    private LivingEntity currentTarget = null;
    @Nullable
    private LivingEntity lastTarget = null;
    private Set<String> bouncedTargets = new LinkedHashSet<String>();
    private ItemStack itemStack = ItemStack.EMPTY;

    public LightningArc(EntityType<? extends LightningArc> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public LivingEntity findClosestEligibleEntity() {
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.position(), this.position()).inflate(this.maxDistance), e -> !EntityUtils.isAlliedTo((Entity)this.getOwner(), (Entity)e) && e != this.currentTarget && !this.bouncedTargets.contains(e.getStringUUID()) && e.isAlive());
        return entities.stream().min(Comparator.comparing(e -> e.position().distanceTo(this.position()))).orElse(null);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
    }

    public void tick() {
        LivingEntity Lowner;
        LivingEntity owner;
        if (this.level().isClientSide || this.tickCount <= 1) {
            return;
        }
        if (this.targetsLeft <= 0) {
            this.discard();
            return;
        }
        this.setTarget(this.findClosestEligibleEntity());
        if (this.getTarget() == null) {
            this.discard();
            return;
        }
        this.setPos(this.getTarget().getEyePosition());
        this.getTarget().invulnerableTime = 0;
        Entity entity = this.getOwner();
        LivingEntity livingEntity = owner = entity instanceof LivingEntity ? (Lowner = (LivingEntity)entity) : null;
        if (this.getTarget().hurt((DamageSource)ItemDamageSource.get(DamageTypeRegistry.ELECTRICITY, this.level(), (Entity)this, (Entity)owner, this.itemStack), (float)this.damage)) {
            entity = this.itemStack.getItem();
            if (entity instanceof IRelicItem) {
                IRelicItem relic = (IRelicItem)entity;
                relic.spreadRelicExperience(owner, this.itemStack, 1);
            }
            this.bouncedTargets.add(this.getTarget().getStringUUID());
            --this.targetsLeft;
            this.getTarget().invulnerableTime = 0;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.currentTarget;
    }

    public void setTarget(LivingEntity livingEntity) {
        this.lastTarget = this.currentTarget;
        this.currentTarget = livingEntity;
        if (!this.level().isClientSide && livingEntity != null) {
            NetworkHandler.sendToClientsTrackingEntity((CustomPacketPayload)new S2CEntityTargetPacket(this.getId(), livingEntity.getId()), (Entity)this);
        }
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public void setTargetsLeft(int targetsLeft) {
        this.targetsLeft = targetsLeft;
    }

    public Set<String> getBouncedTargets() {
        return this.bouncedTargets;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

