/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain.api;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDamageSource
extends DamageSource {
    private ItemStack itemUsed;

    public ItemDamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3 damageSourcePosition, @Nullable ItemStack itemUsed) {
        super(type, directEntity, causingEntity, damageSourcePosition);
        this.itemUsed = itemUsed == null ? ItemStack.EMPTY : itemUsed;
    }

    public static ItemDamageSource get(Holder<DamageType> type, Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3 damageSourcePosition, @Nullable ItemStack itemUsed) {
        return new ItemDamageSource(type, directEntity, causingEntity, damageSourcePosition, itemUsed);
    }

    public static ItemDamageSource get(ResourceKey<DamageType> type, Level level, Entity directEntity, @Nullable Entity causingEntity, @Nullable ItemStack itemUsed) {
        return ItemDamageSource.get((Holder<DamageType>)level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(type), directEntity, causingEntity, null, itemUsed);
    }

    public static ItemDamageSource get(Level level, Entity directEntity, @Nullable Entity causingEntity, @Nullable ItemStack itemUsed) {
        return ItemDamageSource.get((ResourceKey<DamageType>)DamageTypes.GENERIC, level, directEntity, causingEntity, itemUsed);
    }

    @NotNull
    public Component getLocalizedDeathMessage(@NotNull LivingEntity livingEntity) {
        Component component;
        String s = "death.attack." + this.type().msgId();
        if (this.getEntity() == null && this.getDirectEntity() == null) {
            LivingEntity livingentity1 = livingEntity.getKillCredit();
            String s1 = s + ".player";
            return livingentity1 != null ? Component.translatable((String)s1, (Object[])new Object[]{livingEntity.getDisplayName(), livingentity1.getDisplayName()}) : Component.translatable((String)s, (Object[])new Object[]{livingEntity.getDisplayName()});
        }
        Object object = this.getEntity() != null ? this.getEntity().getDisplayName() : (component = this.getDirectEntity() != null ? this.getDirectEntity().getDisplayName() : null);
        return !this.itemUsed.isEmpty() && this.itemUsed.has(DataComponents.CUSTOM_NAME) ? Component.translatable((String)(s + ".item"), (Object[])new Object[]{livingEntity.getDisplayName(), component, this.itemUsed.getDisplayName()}) : (component != null ? Component.translatable((String)(s + ".player"), (Object[])new Object[]{livingEntity.getDisplayName(), component}) : Component.translatable((String)s, (Object[])new Object[]{livingEntity.getDisplayName()}));
    }

    public ItemStack getItemUsed() {
        return this.itemUsed;
    }

    public void setItemUsed(ItemStack itemUsed) {
        this.itemUsed = itemUsed;
    }
}

