/*
 * Decompiled with CFR 0.152.
 */
package meow.binary.relicsofrain;

import com.mojang.logging.LogUtils;
import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailRegistry;
import it.hurts.sskirillss.relics.client.renderer.entities.NullRenderer;
import meow.binary.relicsofrain.client.trail.LightningTrail;
import meow.binary.relicsofrain.item.relic.CrowbarItem;
import meow.binary.relicsofrain.registry.DataComponentRegistry;
import meow.binary.relicsofrain.registry.EntityRegistry;
import meow.binary.relicsofrain.registry.ItemRegistry;
import meow.binary.relicsofrain.registry.KeyMappingRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.slf4j.Logger;

@Mod(value="relicsofrain")
public class RelicsOfRain {
    public static final String MODID = "relicsofrain";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String START_WORLD = "Structures";

    public RelicsOfRain(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ItemRegistry.register(modEventBus);
        EntityRegistry.register(modEventBus);
        DataComponentRegistry.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ItemRegistry.registerEffects();
    }

    @EventBusSubscriber(modid="relicsofrain", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)ItemRegistry.CROWBAR.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"broken"), (stack, level, player, seed) -> CrowbarItem.isBroken(stack) ? 1.0f : 0.0f));
            EntityTrailRegistry.registerProvider((EntityType)((EntityType)EntityRegistry.LIGHTNING_ARC.get()), LightningTrail::new);
        }

        @SubscribeEvent
        public static void keyMappings(RegisterKeyMappingsEvent event) {
            if (!FMLLoader.isProduction()) {
                event.register(KeyMappingRegistry.FREEZE);
            }
        }

        @SubscribeEvent
        public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityRegistry.LIGHTNING_ARC.get(), NullRenderer::new);
        }
    }
}

