/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class EntityFunctions {
    public static Boolean isHorse(Entity entity) {
        return entity instanceof AbstractHorse;
    }

    public static boolean isModdedVillager(String entitystring) {
        String type = entitystring.split("\\[")[0];
        for (String moddedvillager : GlobalVariables.moddedvillagers) {
            if (!type.equalsIgnoreCase(moddedvillager)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(Entity entity) {
        String entitystring = EntityFunctions.getEntityString(entity);
        return EntityFunctions.isModdedVillager(entitystring);
    }

    public static boolean isMilkable(Entity entity) {
        if (entity instanceof Sheep || entity instanceof Llama || entity instanceof Pig || entity instanceof Donkey || entity instanceof Horse || entity instanceof Mule) {
            if (!(entity instanceof Animal)) {
                return false;
            }
            Animal animal = (Animal)entity;
            return !animal.isBaby();
        }
        return false;
    }

    public static String getEntityString(Entity entity) {
        String entitystring = "";
        ResourceLocation rl = EntityType.getKey((EntityType)entity.getType());
        if (rl != null) {
            entitystring = rl.toString();
            if (entitystring.contains(":")) {
                entitystring = entitystring.split(":")[1];
            }
            entitystring = StringFunctions.capitalizeEveryWord(entitystring.replace("_", " ")).replace(" ", "").replace("Entity", "");
        }
        return entitystring;
    }

    public static void nameEntity(Entity entity, String name) {
        if (!name.equals("")) {
            entity.setCustomName((Component)Component.literal((String)name));
        }
    }

    public static void addPotionEffect(Entity entity, MobEffect effect, Integer ms) {
        EntityFunctions.addPotionEffect(entity, (Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), ms);
    }

    public static void addPotionEffect(Entity entity, Holder<MobEffect> mobEffectHolder, Integer ms) {
        MobEffectInstance freeze = new MobEffectInstance(mobEffectHolder, ms / 50);
        LivingEntity le = (LivingEntity)entity;
        le.addEffect(freeze);
    }

    public static void removePotionEffect(Entity entity, MobEffect effect) {
        EntityFunctions.removePotionEffect(entity, (Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect));
    }

    public static void removePotionEffect(Entity entity, Holder<MobEffect> mobEffectHolder) {
        LivingEntity le = (LivingEntity)entity;
        le.removeEffect(mobEffectHolder);
    }

    public static void chargeEntity(Entity entity) {
        Level world = entity.level();
        if (entity instanceof Creeper) {
            entity.getEntityData().set(Creeper.DATA_IS_POWERED, (Object)true);
        } else if (entity instanceof MushroomCow) {
            ((MushroomCow)entity).setVariant(MushroomCow.MushroomType.BROWN);
        }
    }

    public static void setEntityFlag(Entity entity, int flag, boolean set) {
        entity.setSharedFlag(flag, set);
    }

    public static boolean getAbstractHorseEntityFlagResult(AbstractHorse abstractHorse, int flag) {
        return abstractHorse.getFlag(flag);
    }

    public static void resetMerchantOffers(Villager villager) {
        for (MerchantOffer offer : villager.getOffers()) {
            EntityFunctions.resetMerchantOffer(offer);
        }
    }

    public static void resetMerchantOffers(WanderingTrader wanderingTrader) {
        for (MerchantOffer offer : wanderingTrader.getOffers()) {
            EntityFunctions.resetMerchantOffer(offer);
        }
    }

    public static void resetMerchantOffer(MerchantOffer offer) {
        offer.uses = 0;
        offer.maxUses = Integer.MAX_VALUE;
        offer.demand = 0;
    }

    public static void forceSetHealth(LivingEntity livingEntity, float health) {
        livingEntity.getEntityData().set(LivingEntity.DATA_HEALTH_ID, (Object)Float.valueOf(health));
    }

    public static boolean fishingHookHasCatch(FishingHook fishingHook) {
        return fishingHook.biting;
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to, boolean ignoremainhand) {
        if (!(from instanceof Mob)) {
            return;
        }
        Mob mobfrom = (Mob)from;
        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
            ItemStack itemstack;
            if (ignoremainhand && equipmentslottype.equals((Object)EquipmentSlot.MAINHAND) || (itemstack = mobfrom.getItemBySlot(equipmentslottype)).isEmpty()) continue;
            ((LivingEntity)to).setItemSlot(equipmentslottype, itemstack.copy());
        }
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to) {
        EntityFunctions.transferItemsBetweenEntities(from, to, false);
    }

    public static Boolean doesEntitySurviveThisDamage(Player player, int halfheartdamage) {
        return EntityFunctions.doesEntitySurviveThisDamage((LivingEntity)player, halfheartdamage);
    }

    public static Boolean doesEntitySurviveThisDamage(LivingEntity entity, int halfheartdamage) {
        Level level = entity.level();
        float newhealth = entity.getHealth() - (float)halfheartdamage;
        if (!(newhealth > 0.0f)) {
            entity.hurt(level.damageSources().magic(), Float.MAX_VALUE);
            return false;
        }
        entity.hurt(level.damageSources().magic(), 0.1f);
        entity.setHealth(newhealth);
        return true;
    }

    public static Boolean isEntityFromSpawner(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getTags().contains("collective.fromspawner");
    }

    public static void setEntitySize(Entity entity, EntityDimensions entityDimensions, float eyeHight) {
        entity.dimensions = entityDimensions;
        entity.eyeHeight = eyeHight;
    }

    public static GoalSelector getGoalSelector(Mob mob) {
        return mob.goalSelector;
    }

    public static GoalSelector getTargetSelector(Mob mob) {
        return mob.targetSelector;
    }

    public static void setSkullBlockOwner(SkullBlockEntity skullBlockEntity, ResolvableProfile resolvableProfile) {
        skullBlockEntity.setOwner(resolvableProfile);
    }
}

