/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import java.util.Locale;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedLongValue;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum EnergyCubeTier implements ITier,
StringRepresentable
{
    BASIC(BaseTier.BASIC, 4000000L, 4000L),
    ADVANCED(BaseTier.ADVANCED, 16000000L, 16000L),
    ELITE(BaseTier.ELITE, 64000000L, 64000L),
    ULTIMATE(BaseTier.ULTIMATE, 256000000L, 256000L),
    CREATIVE(BaseTier.CREATIVE, Long.MAX_VALUE, Long.MAX_VALUE);

    private final long baseMaxEnergy;
    private final long baseOutput;
    private final BaseTier baseTier;
    @Nullable
    private CachedLongValue storageReference;
    @Nullable
    private CachedLongValue outputReference;

    private EnergyCubeTier(BaseTier tier, long max, long out) {
        this.baseMaxEnergy = max;
        this.baseOutput = out;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public long getMaxEnergy() {
        return this.storageReference == null ? this.getBaseMaxEnergy() : this.storageReference.getOrDefault();
    }

    public long getOutput() {
        return this.outputReference == null ? this.getBaseOutput() : this.outputReference.getOrDefault();
    }

    public long getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public long getBaseOutput() {
        return this.baseOutput;
    }

    public void setConfigReference(CachedLongValue storageReference, CachedLongValue outputReference) {
        this.storageReference = storageReference;
        this.outputReference = outputReference;
    }
}

