/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.item.ItemModule;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.MekanismDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registration.impl.ModuleRegistryObject;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ItemDeferredRegister
extends MekanismDeferredRegister<Item> {
    public ItemDeferredRegister(String modid) {
        super(Registries.ITEM, modid, ItemRegistryObject::new);
    }

    public void register(@NotNull IEventBus bus) {
        super.register(bus);
        bus.addListener(RegisterCapabilitiesEvent.class, event -> this.forEntries(registryObject -> registryObject.registerCapabilities((RegisterCapabilitiesEvent)event)));
        bus.addListener(EventPriority.LOWEST, RegisterEvent.class, event -> {
            if (event.getRegistryKey().equals(Registries.ITEM)) {
                this.forEntries(registryObject -> registryObject.attachDefaultContainers(bus));
            }
        });
        bus.addListener(EventPriority.LOWEST, ModifyDefaultComponentsEvent.class, event -> this.forEntries(registryObject -> {
            if (ContainerType.anySupports((Holder<Item>)registryObject)) {
                event.modify((ItemLike)registryObject, builder -> {
                    for (ContainerType<?, ?, ?> type : ContainerType.TYPES) {
                        type.addDefault((Holder<Item>)registryObject, (DataComponentPatch.Builder)builder);
                    }
                });
            }
        }));
    }

    private void forEntries(Consumer<ItemRegistryObject<?>> consumer) {
        for (Holder entry : this.getEntries()) {
            if (entry instanceof ItemRegistryObject) {
                ItemRegistryObject registryObject = (ItemRegistryObject)entry;
                consumer.accept(registryObject);
                continue;
            }
            if (FMLEnvironment.production) continue;
            throw new IllegalStateException("Expected entry to be an ItemRegistryObject");
        }
    }

    public ItemRegistryObject<Item> register(String name) {
        return this.registerItem(name, Item::new);
    }

    public ItemRegistryObject<Item> registerUnburnable(String name) {
        return this.registerUnburnable(name, Item::new);
    }

    public ItemRegistryObject<Item> register(String name, Rarity rarity) {
        return this.registerItem(name, properties -> new Item(properties.rarity(rarity)));
    }

    public ItemRegistryObject<Item> register(String name, final EnumColor color) {
        return this.registerItem(name, properties -> new Item(this, (Item.Properties)properties){

            @NotNull
            public Component getName(@NotNull ItemStack stack) {
                return TextComponentUtil.build(color, super.getName(stack));
            }
        });
    }

    public ItemRegistryObject<ItemModule> registerModule(ModuleRegistryObject<?> moduleDataSupplier) {
        return this.registerModule(moduleDataSupplier, Rarity.COMMON);
    }

    public ItemRegistryObject<ItemModule> registerModule(ModuleRegistryObject<?> moduleDataSupplier, Rarity rarity) {
        return this.register("module_" + moduleDataSupplier.getName(), () -> ModuleHelper.get().createModuleItem(() -> moduleDataSupplier, new Item.Properties().rarity(rarity)));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> registerItem(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(new Item.Properties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> registerUnburnable(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(new Item.Properties().fireResistant()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Supplier<? extends ITEM> sup) {
        return (ItemRegistryObject)super.register(name, sup);
    }

    public ItemRegistryObject<DeferredSpawnEggItem> registerSpawnEgg(MekanismDeferredHolder<EntityType<?>, ? extends EntityType<? extends Mob>> entityTypeProvider, int primaryColor, int secondaryColor) {
        return this.registerItem(entityTypeProvider.getName() + "_spawn_egg", props -> new DeferredSpawnEggItem((Supplier)((Object)entityTypeProvider), primaryColor, secondaryColor, props));
    }

    public static class StrictProperties
    extends Item.Properties {
        private boolean durabilitySet;
        private boolean toolSet;

        @NotNull
        public Item.Properties durability(int maxDamage) {
            if (!this.durabilitySet) {
                this.durabilitySet = true;
                return super.durability(maxDamage);
            }
            return this;
        }

        @NotNull
        public <T> Item.Properties component(@NotNull DataComponentType<T> component, @NotNull T value) {
            if (component == DataComponents.TOOL) {
                if (this.toolSet) {
                    return this;
                }
                this.toolSet = true;
            }
            return super.component(component, value);
        }
    }
}

