/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.IRadiationSource;
import mekanism.common.config.MekanismConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RadiationSource
implements IRadiationSource {
    private final BlockPos pos;
    private double magnitude;

    public RadiationSource(BlockPos pos, double magnitude) {
        this.pos = pos;
        this.magnitude = magnitude;
    }

    @Override
    @NotNull
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    public GlobalPos getPos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMagnitude() {
        return this.magnitude;
    }

    @Override
    public void radiate(double magnitude) {
        this.magnitude += magnitude;
    }

    @Override
    public boolean decay() {
        this.magnitude *= MekanismConfig.general.radiationSourceDecayRate.get();
        return this.magnitude < IRadiationManager.INSTANCE.minRadiationMagnitude();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadiationSource other = (RadiationSource)o;
        return this.magnitude == other.magnitude && this.pos.equals((Object)other.pos);
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = 31 * result + Double.hashCode(this.magnitude);
        return result;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        tag.putDouble("radiation", this.magnitude);
        return tag;
    }

    @Nullable
    public static RadiationSource deserializeNBT(CompoundTag nbt) {
        Optional blockPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos");
        if (blockPos.isEmpty()) {
            return null;
        }
        return new RadiationSource((BlockPos)blockPos.get(), nbt.getDouble("radiation"));
    }
}

