/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import mekanism.api.math.MathUtils;
import mekanism.common.lib.distribution.SplitInfo;

public class IntegerSplitInfo
extends SplitInfo {
    private int amountToSplit;
    private int amountPerTarget;
    private int sentSoFar;
    private int remainder;

    public IntegerSplitInfo(int amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit;
        this.amountPerTarget = this.toSplitAmong == 0 ? 0 : amountToSplit / this.toSplitAmong;
        this.remainder = this.toSplitAmong == 0 ? 0 : amountToSplit % this.toSplitAmong;
    }

    @Override
    public void send(long amountNeeded) {
        int amountNeededInt = MathUtils.clampToInt(amountNeeded);
        this.amountToSplit -= amountNeededInt;
        this.sentSoFar += amountNeededInt;
        if (!this.decrementTargets) {
            int difference = amountNeededInt - this.amountPerTarget;
            if (difference > 0) {
                this.remainder -= difference;
            }
            return;
        }
        --this.toSplitAmong;
        if (amountNeeded != (long)this.amountPerTarget && this.toSplitAmong != 0) {
            int amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit / this.toSplitAmong;
            this.remainder = this.amountToSplit % this.toSplitAmong;
            if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public long getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public long getRemainderAmount() {
        if (this.toSplitAmong != 0 && this.remainder > 0) {
            return this.amountPerTarget + 1;
        }
        return this.amountPerTarget;
    }

    @Override
    public long getUnsent() {
        return this.amountToSplit;
    }

    @Override
    public long getTotalSent() {
        return this.sentSoFar;
    }
}

