/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class ChemicalDissolutionRecipeCategory
extends HolderRecipeCategory<ChemicalDissolutionRecipe> {
    private final GuiGauge<?> inputGauge;
    private final GuiGauge<?> outputGauge;
    private final GuiSlot inputSlot;

    public ChemicalDissolutionRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ChemicalDissolutionRecipe> recipeType) {
        super(helper, recipeType);
        GaugeType type1 = GaugeType.STANDARD.with(DataType.INPUT);
        this.inputGauge = this.addElement(GuiChemicalGauge.getDummy(type1, this, 7, 4));
        GaugeType type = GaugeType.STANDARD.with(DataType.OUTPUT);
        this.outputGauge = this.addElement(GuiChemicalGauge.getDummy(type, this, 131, 13));
        this.inputSlot = this.addSlot(SlotType.INPUT, 28, 36);
        this.addSlot(SlotType.EXTRA, 8, 65).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.OUTPUT, 152, 55).with(SlotOverlay.PLUS);
        this.addSlot(SlotType.POWER, 152, 14).with(SlotOverlay.POWER);
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 64, 40);
        this.addElement(new GuiHorizontalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 115, 75));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ChemicalDissolutionRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ChemicalDissolutionRecipe recipe = (ChemicalDissolutionRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.inputSlot, recipe.getItemInput().getRepresentations());
        List<ChemicalStack> scaledChemicals = recipe.getChemicalInput().getRepresentations();
        if (recipe.perTickUsage()) {
            scaledChemicals = scaledChemicals.stream().map(chemical -> chemical.copyWithAmount(chemical.getAmount() * 100L)).toList();
        }
        this.initChemical(builder, RecipeIngredientRole.INPUT, this.inputGauge, scaledChemicals);
        this.initChemical(builder, RecipeIngredientRole.OUTPUT, this.outputGauge, recipe.getOutputDefinition());
    }
}

