/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

@NothingNullByDefault
public interface IItemStackIngredientCreator
extends IIngredientCreator<Item, ItemStack, ItemStackIngredient> {
    @Override
    default public ItemStackIngredient from(ItemStack instance) {
        Objects.requireNonNull(instance, "ItemStackIngredients cannot be created from a null ItemStack.");
        return this.from(instance, instance.getCount());
    }

    @Override
    default public ItemStackIngredient from(ItemStack stack, int amount) {
        Objects.requireNonNull(stack, "ItemStackIngredients cannot be created from a null ItemStack.");
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created using the empty stack.");
        }
        DataComponentPredicate predicate = IngredientCreatorAccess.getComponentPatchPredicate((stack = stack.copy()).getComponentsPatch());
        if (predicate != null) {
            return this.from(DataComponentIngredient.of((boolean)false, (DataComponentPredicate)predicate, (Holder[])new Holder[]{stack.getItemHolder()}), amount);
        }
        return this.from(Ingredient.of((ItemStack[])new ItemStack[]{stack}), amount);
    }

    default public ItemStackIngredient fromHolder(Holder<Item> item) {
        return (ItemStackIngredient)this.fromHolder(item, 1);
    }

    @Override
    default public ItemStackIngredient from(ItemLike item) {
        return this.from(item, 1);
    }

    @Override
    default public ItemStackIngredient from(ItemLike item, int amount) {
        return this.from(Ingredient.of((ItemLike[])new ItemLike[]{item}), amount);
    }

    @Override
    default public ItemStackIngredient from(ItemLike ... items) {
        return this.from(1, items);
    }

    default public ItemStackIngredient from(int amount, ItemLike ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Attempted to create an ItemStackIngredient with no items.");
        }
        return this.from(Ingredient.of((ItemLike[])items), amount);
    }

    @Override
    default public ItemStackIngredient from(Item item, int amount) {
        return this.from(Ingredient.of((ItemLike[])new ItemLike[]{item}), amount);
    }

    default public ItemStackIngredient from(int amount, Item ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Attempted to create an ItemStackIngredient with no items.");
        }
        return this.from(Ingredient.of((ItemLike[])items), amount);
    }

    @Override
    default public ItemStackIngredient fromHolders(int amount, Holder<Item> ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Attempted to create a ItemStackIngredient with no items.");
        }
        return this.from(Ingredient.of(Arrays.stream(items).map(ItemStack::new)), amount);
    }

    @Override
    default public ItemStackIngredient from(TagKey<Item> tag) {
        return this.from((TagKey)tag, 1);
    }

    @Override
    default public ItemStackIngredient from(TagKey<Item> tag, int amount) {
        Objects.requireNonNull(tag, "ItemStackIngredients cannot be created from a null tag.");
        return this.from(Ingredient.of(tag), amount);
    }

    default public ItemStackIngredient from(int amount, List<TagKey<Item>> tags) {
        if (tags.isEmpty()) {
            throw new IllegalArgumentException("Attempted to create an ItemStackIngredient with no tags.");
        }
        return this.from(Ingredient.fromValues(tags.stream().map(Ingredient.TagValue::new)), amount);
    }

    @Override
    default public ItemStackIngredient from(Ingredient ingredient) {
        return this.from(ingredient, 1);
    }

    @Override
    default public ItemStackIngredient from(Ingredient ingredient, int amount) {
        Objects.requireNonNull(ingredient, "ItemStackIngredients cannot be created from a null ingredient.");
        return this.from(new SizedIngredient(ingredient, amount));
    }

    @Override
    default public ItemStackIngredient from(SizedIngredient ingredient) {
        return ItemStackIngredient.of(ingredient);
    }

    default public ItemStackIngredient from(HolderLookup.Provider registries, ResourceLocation itemId) {
        return this.fromHolder((Holder<Item>)registries.lookupOrThrow(Registries.ITEM).getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)itemId)));
    }
}

