/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.attribute;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.datamaps.chemical.attribute.ChemicalFuel;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true, since="10.7.11")
public class ChemicalAttributes {
    private ChemicalAttributes() {
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static class Fuel
    extends ChemicalAttribute {
        @Nullable
        private final ChemicalFuel modernRepresentation;
        private final IntSupplier burnTicks;
        private final LongSupplier energyDensity;

        public Fuel(int burnTicks, long energyDensity) {
            long energyPerTick = energyDensity / (long)burnTicks;
            if (energyPerTick < 0L) {
                this.modernRepresentation = null;
                this.burnTicks = () -> burnTicks;
                this.energyDensity = () -> energyDensity;
            } else {
                this.modernRepresentation = new ChemicalFuel(burnTicks, energyPerTick);
                this.burnTicks = this.modernRepresentation::burnTicks;
                this.energyDensity = this.modernRepresentation::energyDensity;
            }
        }

        public Fuel(ChemicalFuel modernRepresentation) {
            this.modernRepresentation = modernRepresentation;
            this.burnTicks = modernRepresentation::burnTicks;
            this.energyDensity = modernRepresentation::energyDensity;
        }

        public Fuel(IntSupplier burnTicks, LongSupplier energyDensity) {
            this.modernRepresentation = null;
            this.burnTicks = burnTicks;
            this.energyDensity = energyDensity;
        }

        public int getBurnTicks() {
            return this.burnTicks.getAsInt();
        }

        public long getEnergyPerTick() {
            int ticks = this.getBurnTicks();
            if (ticks < 1) {
                MekanismAPI.logger.warn("Invalid tick count ({}) for Fuel attribute, this number should be at least 1.", (Object)ticks);
                return 0L;
            }
            if (ticks == 1) {
                return this.energyDensity.getAsLong();
            }
            return this.energyDensity.getAsLong() / (long)ticks;
        }

        @Override
        @ApiStatus.Internal
        @Nullable
        public ChemicalFuel asModern() {
            if (this.modernRepresentation != null) {
                return this.modernRepresentation;
            }
            int ticks = this.getBurnTicks();
            if (ticks < 1) {
                MekanismAPI.logger.warn("Invalid tick count ({}) for Fuel attribute, this number should be at least 1.", (Object)ticks);
                return null;
            }
            long density = this.energyDensity.getAsLong();
            long energyPerTick = density / (long)ticks;
            if (energyPerTick == 0L) {
                MekanismAPI.logger.warn("Invalid energy density ({}) for Fuel attribute, this number when divided by ticks should be at least 1.", (Object)density);
                return null;
            }
            try {
                return new ChemicalFuel(ticks, energyPerTick);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        @Override
        @Deprecated(forRemoval=true, since="10.7.4")
        public List<Component> addTooltipText(List<Component> list) {
            this.collectTooltips(list::add);
            return list;
        }

        @Override
        public void collectTooltips(Consumer<Component> adder) {
            ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_FUEL_BURN_TICKS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getFormattedNumber(this.getBurnTicks())));
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_FUEL_ENERGY_DENSITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getEnergyPerMBDisplayShort(this.energyDensity.getAsLong())));
        }
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static non-sealed class HeatedCoolant
    extends Coolant {
        @Nullable
        private final mekanism.api.datamaps.chemical.attribute.HeatedCoolant modernRepresentation;
        @Deprecated(forRemoval=true, since="10.7.11")
        private final IChemicalProvider cooledChemical;

        @Deprecated(forRemoval=true, since="10.7.11")
        public HeatedCoolant(IChemicalProvider cooledChemical, double thermalEnthalpy, double conductivity) {
            super(thermalEnthalpy, conductivity);
            this.cooledChemical = cooledChemical;
            this.modernRepresentation = null;
        }

        public HeatedCoolant(Holder<Chemical> cooledChemical, double thermalEnthalpy) {
            this(new mekanism.api.datamaps.chemical.attribute.HeatedCoolant(cooledChemical, thermalEnthalpy));
        }

        public HeatedCoolant(mekanism.api.datamaps.chemical.attribute.HeatedCoolant coolant) {
            super(coolant.thermalEnthalpy(), 1.0);
            this.modernRepresentation = coolant;
            this.cooledChemical = () -> (Chemical)this.modernRepresentation.otherVariant().value();
        }

        public Chemical getCooledChemical() {
            return this.cooledChemical.getChemical();
        }

        @Override
        @ApiStatus.Internal
        @Nullable
        public mekanism.api.datamaps.chemical.attribute.HeatedCoolant asModern() {
            if (this.modernRepresentation != null) {
                return this.modernRepresentation;
            }
            Chemical chemical = this.cooledChemical.getChemical();
            if (chemical.isEmptyType()) {
                return null;
            }
            try {
                return new mekanism.api.datamaps.chemical.attribute.HeatedCoolant(chemical.getAsHolder(), this.getThermalEnthalpy());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static non-sealed class CooledCoolant
    extends Coolant {
        @Nullable
        private final mekanism.api.datamaps.chemical.attribute.CooledCoolant modernRepresentation;
        @Deprecated(forRemoval=true, since="10.7.11")
        private final IChemicalProvider heatedChemical;

        @Deprecated(forRemoval=true, since="10.7.11")
        public CooledCoolant(IChemicalProvider heatedChemical, double thermalEnthalpy, double conductivity) {
            super(thermalEnthalpy, conductivity);
            this.heatedChemical = heatedChemical;
            this.modernRepresentation = null;
        }

        public CooledCoolant(Holder<Chemical> heatedChemical, double thermalEnthalpy, double conductivity) {
            this(new mekanism.api.datamaps.chemical.attribute.CooledCoolant(heatedChemical, thermalEnthalpy, conductivity));
        }

        public CooledCoolant(mekanism.api.datamaps.chemical.attribute.CooledCoolant coolant) {
            super(coolant.thermalEnthalpy(), coolant.conductivity());
            this.modernRepresentation = coolant;
            this.heatedChemical = () -> (Chemical)this.modernRepresentation.otherVariant().value();
        }

        public Chemical getHeatedChemical() {
            return this.heatedChemical.getChemical();
        }

        @Override
        @ApiStatus.Internal
        @Nullable
        public mekanism.api.datamaps.chemical.attribute.CooledCoolant asModern() {
            if (this.modernRepresentation != null) {
                return this.modernRepresentation;
            }
            Chemical chemical = this.heatedChemical.getChemical();
            if (chemical.isEmptyType()) {
                return null;
            }
            try {
                return new mekanism.api.datamaps.chemical.attribute.CooledCoolant(chemical.getAsHolder(), this.getThermalEnthalpy(), this.getConductivity());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static abstract sealed class Coolant
    extends ChemicalAttribute
    permits CooledCoolant, HeatedCoolant {
        private final double thermalEnthalpy;
        private final double conductivity;

        private Coolant(double thermalEnthalpy, double conductivity) {
            if (thermalEnthalpy <= 0.0) {
                throw new IllegalArgumentException("Coolant attributes must have a thermal enthalpy greater than zero! Thermal Enthalpy: " + thermalEnthalpy);
            }
            if (conductivity <= 0.0 || conductivity > 1.0) {
                throw new IllegalArgumentException("Coolant attributes must have a conductivity greater than zero and at most one! Conductivity: " + conductivity);
            }
            this.thermalEnthalpy = thermalEnthalpy;
            this.conductivity = conductivity;
        }

        public double getThermalEnthalpy() {
            return this.thermalEnthalpy;
        }

        public double getConductivity() {
            return this.conductivity;
        }

        @Override
        @Deprecated(forRemoval=true, since="10.7.4")
        public List<Component> addTooltipText(List<Component> list) {
            this.collectTooltips(list::add);
            return list;
        }

        @Override
        public void collectTooltips(Consumer<Component> adder) {
            ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_EFFICIENCY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getPercent(this.conductivity)));
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_ENTHALPY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getEnergyPerMBDisplayShort(MathUtils.clampToLong(this.thermalEnthalpy))));
        }
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static class Radiation
    extends ChemicalAttribute {
        @Nullable
        private final ChemicalRadioactivity modernRepresentation;
        private final double radioactivity;

        public Radiation(double radioactivity) {
            if (radioactivity <= 0.0) {
                throw new IllegalArgumentException("Radiation attribute should only be used when there actually is radiation! Radioactivity: " + radioactivity);
            }
            this.radioactivity = radioactivity;
            this.modernRepresentation = radioactivity <= IRadiationManager.INSTANCE.baselineRadiation() ? null : new ChemicalRadioactivity(radioactivity);
        }

        public Radiation(ChemicalRadioactivity modern) {
            this.modernRepresentation = Objects.requireNonNull(modern);
            this.radioactivity = modern.radioactivity();
        }

        @Override
        @ApiStatus.Internal
        @Nullable
        public ChemicalRadioactivity asModern() {
            return this.modernRepresentation;
        }

        public double getRadioactivity() {
            return this.radioactivity;
        }

        @Override
        public boolean needsValidation() {
            return IRadiationManager.INSTANCE.isRadiationEnabled();
        }

        @Override
        @Deprecated(forRemoval=true, since="10.7.4")
        public List<Component> addTooltipText(List<Component> list) {
            this.collectTooltips(list::add);
            return list;
        }

        @Override
        public void collectTooltips(Consumer<Component> adder) {
            if (this.needsValidation()) {
                ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
                adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_RADIATION.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getRadioactivityDisplayShort(this.getRadioactivity())));
            }
        }
    }
}

