/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.platform;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.MissingHandlerEvent;
import shetiphian.endertanks.common.NeoForgeFluidUtil;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;
import shetiphian.endertanks.modintegration.handlers.TypeFluid;
import shetiphian.endertanks.platform.IPlatformHelper;

public final class NeoForgePlatform
implements IPlatformHelper {
    @Override
    public InteractionResult transferFromItem(TileEntityEnderTank tankTile, ItemStack stack, Player player, InteractionHand hand) {
        IFluidHandler tankHandler = tankTile.getEnderContainer().getTankFor(IFluidHandler.class).orElse(null);
        IFluidHandler containerHandler = NeoForgeFluidUtil.getHandler(stack.copy().split(1));
        if (tankHandler != null && containerHandler != null) {
            NeoForgeFluidUtil.interactWithFluidHandler(player, hand, tankHandler);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean pickupLiquid(ItemStack stack, Player player, InteractionHand hand, Level world, BlockPos pos, Direction facing) {
        if (world.mayInteract(player, pos) && player.mayUseItemAt(pos, facing, stack)) {
            Fluid fluid;
            FluidStack getLiquid;
            int getAmount;
            IFluidHandler bucketTank = TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(IFluidHandler.class).orElse(null);
            if (bucketTank == null) {
                return false;
            }
            IFluidHandler fromHandler = NeoForgeFluidUtil.getHandler(world, pos, facing);
            FluidStack bucketLiquid = bucketTank.getFluidInTank(0);
            int n = getAmount = !bucketLiquid.isEmpty() ? Math.min(1000, bucketTank.getTankCapacity(0) - bucketLiquid.getAmount()) : 1000;
            if (fromHandler != null && !(getLiquid = NeoForgeFluidUtil.tryFluidTransfer(bucketTank, fromHandler, getAmount, true)).isEmpty()) {
                this.playFluidSound(getLiquid.getFluid(), world, pos, false);
                if (player.getAbilities().instabuild) {
                    bucketTank.drain(getLiquid, IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
            if (getAmount >= 1000 && (fluid = NeoForgeFluidUtil.tryPickupFluid(player, world, pos, bucketLiquid.isEmpty() ? Fluids.EMPTY : bucketLiquid.getFluid())) != Fluids.EMPTY) {
                this.playFluidSound(fluid, world, pos, false);
                if (!player.getAbilities().instabuild) {
                    bucketTank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        }
        return false;
    }

    private void playFluidSound(Fluid fluid, Level world, BlockPos pos, boolean empty) {
        SoundEvent soundEvent = fluid.getFluidType().getSound(null, (BlockGetter)world, pos, empty ? SoundActions.BUCKET_EMPTY : SoundActions.BUCKET_FILL);
        soundEvent = soundEvent != null ? soundEvent : (fluid.is(FluidTags.LAVA) ? (empty ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_FILL_LAVA) : (empty ? SoundEvents.BUCKET_EMPTY : SoundEvents.BUCKET_FILL));
        world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.gameEvent(null, (Holder)(empty ? GameEvent.FLUID_PLACE : GameEvent.FLUID_PICKUP), pos);
    }

    @Override
    public boolean placeLiquid(ItemStack stack, Player player, InteractionHand hand, Level world, BlockPos pos, Direction facing, boolean hitTypeBlock) {
        IFluidHandler bucketTank = TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(IFluidHandler.class).orElse(null);
        if (bucketTank == null) {
            return false;
        }
        FluidStack bucketLiquid = bucketTank.getFluidInTank(0);
        int putAmount = !bucketLiquid.isEmpty() ? Math.min(1000, bucketLiquid.getAmount()) : 0;
        IFluidHandler toHandler = NeoForgeFluidUtil.getHandler(world, pos, facing);
        if (toHandler != null) {
            FluidStack putLiquid;
            if (world.mayInteract(player, pos) && player.mayUseItemAt(pos, facing, stack) && !(putLiquid = NeoForgeFluidUtil.tryFluidTransfer(toHandler, bucketTank, putAmount, true)).isEmpty()) {
                this.playFluidSound(putLiquid.getFluid(), world, pos, true);
                if (player.getAbilities().instabuild) {
                    bucketTank.fill(putLiquid, IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        } else if (putAmount >= 1000 && hitTypeBlock) {
            FluidStack placeLiquid = bucketTank.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            BlockPos sPos = pos;
            for (int attempt = 0; attempt < 2; attempt = (int)((byte)(attempt + 1))) {
                if (world.mayInteract(player, sPos) && player.mayUseItemAt(sPos, facing, stack) && NeoForgeFluidUtil.tryPlaceFluid(player, world, sPos, placeLiquid.getFluid(), facing)) {
                    world.neighborChanged(sPos, Blocks.AIR, sPos);
                    this.playFluidSound(placeLiquid.getFluid(), world, pos, true);
                    if (!player.getAbilities().instabuild) {
                        bucketTank.drain(placeLiquid, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return true;
                }
                sPos = pos.relative(facing);
            }
        }
        return false;
    }

    @Override
    public boolean isBucketHandler(ITankHandler<?> handler) {
        return handler instanceof TypeFluid.FluidTankHandler;
    }

    @Override
    public InteractionResultHolder<String> fireMissingHandlerEvent(String providerId, CompoundTag saveData) {
        MissingHandlerEvent event = new MissingHandlerEvent(providerId, saveData);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.getResult();
        }
        return InteractionResultHolder.pass((Object)"");
    }
}

