/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.theoneprobe;

import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public final class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private static final ResourceLocation INFO_PROVIDER_ID = EnderTanks.RESOURCE.apply("default");
    private static final ResourceLocation ELEMENT_ID = EnderTanks.RESOURCE.apply("element");

    public ResourceLocation getID() {
        return INFO_PROVIDER_ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        if (blockState.getBlock() instanceof BlockEnderTank && (tile = world.getBlockEntity(data.getPos())) instanceof TileEntityEnderTank) {
            probeInfo.element((IElement)new ElementTankInfo((TileEntityEnderTank)tile, !mode.equals((Object)ProbeMode.NORMAL)));
        }
    }

    private static class ElementTankInfo
    implements IElement {
        private static final ResourceLocation COMPARATOR = ResourceLocation.parse((String)"textures/item/comparator.png");
        private TileEntityEnderTank tank;
        private boolean showDetails;
        private CompoundTag data;
        private final List<Component> lines = new ArrayList<Component>();
        private boolean renderIcon;

        private ElementTankInfo(TileEntityEnderTank tank, boolean showDetails) {
            this.tank = tank;
            this.showDetails = showDetails;
        }

        private ElementTankInfo(CompoundTag data, HolderLookup.Provider provider) {
            if (data == null || data.isEmpty()) {
                this.data = new CompoundTag();
                return;
            }
            this.data = data;
            if (data.contains("basic")) {
                TankInfoHelper.unpackHUDInfo(this.lines, data.getList("basic", 8), provider);
            }
            if (data.contains("contents")) {
                TankInfoHelper.unpackHUDInfo(this.lines, data.getList("contents", 8), provider);
            }
            if (data.contains("status")) {
                this.renderIcon = true;
                TankInfoHelper.unpackHUDInfo(this.lines, data.getList("status", 8), provider);
            }
        }

        public void render(GuiGraphics graphics, int x, int y) {
            int indent = this.lines.size() - 1;
            int counter = 0;
            for (Component line : this.lines) {
                ElementTextRender.render((Component)line, (GuiGraphics)graphics, (int)(counter < indent ? x : x + 10), (int)y);
                y += 10;
                ++counter;
            }
            if (this.renderIcon) {
                GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(x + 3), (double)(y - 10), (int)0, (int)0, (int)16, (int)16, (double)0.5, (int)16, (int)16, (ResourceLocation)COMPARATOR);
            }
        }

        public int getWidth() {
            int width = 0;
            for (Component line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((Component)line));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(RegistryFriendlyByteBuf buffer) {
            if (this.data == null && this.tank != null) {
                this.data = new CompoundTag();
                this.data.put("basic", (Tag)TankInfoHelper.packHUDBasic(this.tank, (HolderLookup.Provider)buffer.registryAccess()));
                if (this.showDetails) {
                    this.data.put("contents", (Tag)TankInfoHelper.packHUDContents(this.tank, (HolderLookup.Provider)buffer.registryAccess()));
                    this.data.put("status", (Tag)TankInfoHelper.packHUDStatus(this.tank, (HolderLookup.Provider)buffer.registryAccess()));
                }
            }
            if (this.data != null) {
                buffer.writeNbt((Tag)this.data);
            }
        }

        public ResourceLocation getID() {
            return ELEMENT_ID;
        }
    }

    static class ElementFactoryTankInfo
    implements IElementFactory {
        ElementFactoryTankInfo() {
        }

        public IElement createElement(RegistryFriendlyByteBuf buffer) {
            return new ElementTankInfo(buffer.readNbt(), (HolderLookup.Provider)buffer.registryAccess());
        }

        public ResourceLocation getId() {
            return ELEMENT_ID;
        }
    }
}

