/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import com.google.common.base.Strings;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.NameCache;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.ILoadStateAware;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.component.EnderNetwork;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IRGB16_Tile,
ILoadStateAware {
    private EnderNetwork network = EnderNetwork.DEFAULT;
    private final ArrayList<ItemStack> pumpUpgrades = new ArrayList();
    public long lastClick = 0L;
    private final List<String> usedUpgrades = new ArrayList<String>();
    private String comparedHandler = "";

    public TileEntityEnderTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.ENDERTANK.get(), pos, state);
    }

    public void buildNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        nbtTag.put("network", (Tag)EnderNetwork.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.network).getOrThrow());
        if (!this.pumpUpgrades.isEmpty()) {
            ListTag listItems = new ListTag();
            for (ItemStack stack : this.pumpUpgrades) {
                listItems.add((Object)stack.save(provider));
            }
            nbtTag.put("upgrade.pump", (Tag)listItems);
        }
        if (!this.usedUpgrades.isEmpty()) {
            ListTag listNBT = new ListTag();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)StringTag.valueOf((String)upgrade));
            }
            nbtTag.put("used_upgrades", (Tag)listNBT);
        }
        if (!Strings.isNullOrEmpty((String)this.comparedHandler)) {
            nbtTag.putString("compared", this.comparedHandler);
        }
    }

    public void processNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (!nbtTag.contains("network")) {
            this.migrate(nbtTag, provider);
        } else {
            EnderNetwork.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbtTag.get("network")).resultOrPartial().ifPresent(enderNetwork -> {
                this.network = enderNetwork;
            });
        }
        if (nbtTag.contains("upgrade.pump", 9)) {
            this.pumpUpgrades.clear();
            ListTag listItems = nbtTag.getList("upgrade.pump", 10);
            for (int entry2 = 0; entry2 < listItems.size(); ++entry2) {
                CompoundTag compound = listItems.getCompound(entry2);
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound);
                if (stack.isEmpty()) continue;
                if (stack.getCount() != 1) {
                    stack.setCount(1);
                }
                this.pumpUpgrades.add(stack);
            }
        }
        if (nbtTag.contains("used_upgrades", 9)) {
            this.usedUpgrades.clear();
            ListTag listNBT = nbtTag.getList("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.getAsString()));
        }
        this.comparedHandler = nbtTag.getString("compared");
    }

    private void migrate(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (nbtTag.contains("code", 8)) {
            this.setCode(nbtTag.getString("code"));
        }
        String owner = null;
        if (nbtTag.contains("owner.id", 8)) {
            owner = nbtTag.getString("owner.id");
            String string = owner = StackHelper.isValidOwnerID(owner) ? owner : null;
        }
        if (owner == null && nbtTag.contains("owner_id", 8)) {
            owner = nbtTag.getString("owner_id");
            String string = owner = StackHelper.isValidOwnerID(owner) ? owner : null;
        }
        if (owner != null) {
            String id;
            ItemStack stack = ItemStack.EMPTY;
            if (nbtTag.contains("upgrade.access", 10)) {
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("upgrade.access"));
                if (!stack.isEmpty() && stack.getCount() != 1) {
                    stack.setCount(1);
                }
            } else if (nbtTag.contains("personal", 8) && !Strings.isNullOrEmpty((String)(id = nbtTag.getString("personal")))) {
                try {
                    stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.network = new EnderNetwork(owner, this.network.code(), stack);
        }
    }

    public void processNBT_SaveOnly(CompoundTag nbtTag, HolderLookup.Provider provider) {
        super.processNBT_SaveOnly(nbtTag, provider);
        if (nbtTag.contains("owner.id", 8) && nbtTag.contains("owner", 8)) {
            NameCache.addPlayerNameIfMissing((String)nbtTag.getString("owner.id"), (String)nbtTag.getString("owner"));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)this.network);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.network = (EnderNetwork)components.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
    }

    public boolean applyItem(ItemStack stack) {
        String key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.invalidateCaps();
    }

    public void invalidateCaps() {
        EnderTanks.CAPABILITY_DEVALID_INATOR.accept((BlockEntity)this);
    }

    public <T> T getTankStorage(Class<T> type, Direction facing) {
        Optional<T> optional;
        StorageAccessMode accessMode;
        if (this.canBeAutomated() && (accessMode = this.getAccessFor(facing)) != null && (optional = this.getEnderContainer().getTankFor(type, accessMode)).isPresent()) {
            return optional.get();
        }
        return null;
    }

    public boolean isAccessibleFrom(Direction facing) {
        return this.canBeAutomated() && this.getAccessFor(facing) != null;
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? (Boolean)Configs.ACCESS_SETTINGS.enableAutomationPublic.get() : (this.isTeam() ? (Boolean)Configs.ACCESS_SETTINGS.enableAutomationTeam.get() : (Boolean)Configs.ACCESS_SETTINGS.enableAutomationPersonal.get());
    }

    private StorageAccessMode getAccessFor(Direction facing) {
        Direction tFacing;
        if (facing == null) {
            return StorageAccessMode.FULL;
        }
        BlockState state = this.getBlockState();
        if (state != null && (tFacing = BlockEnderTank.getFacing(state)).getAxis() == facing.getAxis()) {
            if (BlockEnderTank.isPowered(state)) {
                return facing == tFacing ? StorageAccessMode.EXTRACT_ONLY : StorageAccessMode.INSERT_ONLY;
            }
            return StorageAccessMode.FULL;
        }
        return null;
    }

    public EnderContainer getEnderContainer() {
        return TankHelper.getTank(this.level, this.getOwnerID(), this.getCode());
    }

    public int getComparatorOutput() {
        if (Strings.isNullOrEmpty((String)this.comparedHandler)) {
            this.useDefaultHandler();
        }
        if (!Strings.isNullOrEmpty((String)this.comparedHandler)) {
            int result = this.getEnderContainer().getComparatorOutput(this.comparedHandler);
            if (result > -1) {
                return result;
            }
            if (!this.comparedHandler.equals(HandlerRegistry.DEFAULT_KEY.toString())) {
                this.useDefaultHandler();
            }
        }
        return 0;
    }

    private void useDefaultHandler() {
        this.comparedHandler = HandlerRegistry.DEFAULT_KEY.toString();
        if (this.level != null) {
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    public boolean compareNextHandler(Player player) {
        if (player != null && this.canEdit(player)) {
            String firstEntry = null;
            boolean target = false;
            boolean changed = false;
            for (String key : HandlerRegistry.getProviders().keySet()) {
                if (firstEntry == null) {
                    firstEntry = key;
                    if (Strings.isNullOrEmpty((String)this.comparedHandler)) {
                        this.comparedHandler = key;
                        changed = true;
                        break;
                    }
                }
                if (target) {
                    this.comparedHandler = key;
                    changed = true;
                    break;
                }
                if (!key.equals(this.comparedHandler)) continue;
                target = true;
            }
            if (!(changed || Strings.isNullOrEmpty(firstEntry) || firstEntry.equals(this.comparedHandler))) {
                this.comparedHandler = firstEntry;
                changed = true;
            }
            player.displayClientMessage((Component)Component.literal((String)" :").append((Component)Component.translatable((String)Items.COMPARATOR.getDescriptionId())).append(" ").append(this.getComparatorTypeDisplayName()), true);
            return changed;
        }
        return false;
    }

    public Component getComparatorTypeDisplayName() {
        return this.getEnderContainer().getDisplayName(this.comparedHandler);
    }

    public byte getPumpInBuckets() {
        int upgrades = this.getPumpUpgradeCount();
        return (byte)(upgrades == 0 && (Boolean)Configs.UPGRADE_SETTINGS.hasStarterPump.get() != false ? -1 : upgrades);
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(ItemStack stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(Player player) {
        return this.canEdit(player, true);
    }

    public boolean canEdit(Player player, boolean notify) {
        boolean canEdit = true;
        String msg = "";
        if (!player.getAbilities().instabuild) {
            if (this.isTeam()) {
                canEdit = (Boolean)Configs.ACCESS_SETTINGS.lockTeamEdit.get() == false || this.network.id().equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = (Boolean)Configs.ACCESS_SETTINGS.lockPersonalEdit.get() == false || !Strings.isNullOrEmpty((String)this.network.id()) && this.network.id().equals(player.getUUID().toString());
                msg = "private.denied";
            }
        }
        if (notify && !canEdit && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canEdit;
    }

    public boolean canUse(Player player) {
        boolean canUse = true;
        String msg = "";
        if (!player.getAbilities().instabuild) {
            if (this.isTeam()) {
                canUse = (Boolean)Configs.ACCESS_SETTINGS.lockTeamUse.get() == false || this.network.id().equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = (Boolean)Configs.ACCESS_SETTINGS.allowPublicTanks.get();
                msg = "public.disabled";
            } else {
                canUse = (Boolean)Configs.ACCESS_SETTINGS.lockPersonalUse.get() == false || !Strings.isNullOrEmpty((String)this.network.id()) && this.network.id().equals(player.getUUID().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canUse;
    }

    public boolean canLink(Player player) {
        boolean canLink = true;
        String msg = "";
        if (!player.getAbilities().instabuild) {
            if (this.isTeam()) {
                if (((Boolean)Configs.ACCESS_SETTINGS.allowTeamBuckets.get()).booleanValue()) {
                    canLink = (Boolean)Configs.ACCESS_SETTINGS.lockTeamLink.get() == false || this.network.id().equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "tank.team.denied";
                } else {
                    canLink = false;
                    msg = "bucket.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (((Boolean)Configs.ACCESS_SETTINGS.allowPersonalBuckets.get()).booleanValue()) {
                    canLink = (Boolean)Configs.ACCESS_SETTINGS.lockPersonalLink.get() == false || !Strings.isNullOrEmpty((String)this.network.id()) && this.network.id().equals(player.getUUID().toString());
                    msg = "tank.private.denied";
                } else {
                    canLink = false;
                    msg = "bucket.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(Player player) {
        String team = Helpers.getPlayerTeamID((Player)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    public String getOwnerID() {
        if (!Strings.isNullOrEmpty((String)this.network.id())) {
            return this.network.id();
        }
        return "all";
    }

    public String getOwnerName() {
        return TankInfoHelper.getDisplayNameFromOwnerID(this.network.id());
    }

    public void setOwner(Player player, ItemStack stack) {
        this.clearMyLocation();
        this.network = new EnderNetwork(player.getUUID().toString(), this.network.code(), stack);
        this.setMyLocation();
    }

    public void setOwner(String ownerID, ItemStack stack) {
        if (StackHelper.isValidOwnerID(ownerID)) {
            this.clearMyLocation();
            this.network = new EnderNetwork(ownerID, this.network.code(), stack);
            this.setMyLocation();
        }
    }

    public ItemStack getPersonalItem() {
        if (!this.network.stack().isEmpty()) {
            if (this.network.stack().getCount() != 1) {
                this.network.stack().setCount(1);
            }
            return this.network.stack();
        }
        return ItemStack.EMPTY;
    }

    public ArrayList<ItemStack> getPumpUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (!this.pumpUpgrades.isEmpty()) {
            for (ItemStack stack : this.pumpUpgrades) {
                if (stack == null) continue;
                if (stack.getCount() != 1) {
                    stack.setCount(1);
                }
                upgrades.add(stack);
            }
        }
        return upgrades;
    }

    public boolean isPublic() {
        return Strings.isNullOrEmpty((String)this.network.id()) || this.network.id().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.network.id() != null && this.network.id().startsWith("#");
    }

    public String getCode() {
        return StackHelper.formatCode(this.network.code());
    }

    public void setCode(String code) {
        this.clearMyLocation();
        this.network = new EnderNetwork(this.network.id(), StackHelper.formatCode(code), this.network.stack());
        this.setMyLocation();
        this.invalidateCaps();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.network.id());
    }

    public RGB16 getRGB16(Player player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(DyeColor.byId((int)value).getName());
    }

    public boolean setRGB16(short rgbIndex, Player player) {
        return this.doColorRing(DyeColor.byId((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(DyeColor color, Player player) {
        if (player == null || !this.canEdit(player) || !((Boolean)Configs.GENERAL.inWorldRecoloring.get()).booleanValue()) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.getId()).toUpperCase().charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Helpers.syncTile((BlockEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(Player player) {
        VoxelShape[] shapes = BlockEnderTank.SHAPES.get(this.getBlockState().getValue((Property)BlockEnderTank.FACING));
        return Helpers.getSubShapeHit((Entity)player, (BlockPos)this.worldPosition, (VoxelShape[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.level != null && !this.level.isClientSide()) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.level != null && !this.level.isClientSide()) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void nowLoaded() {
        this.setMyLocation();
    }

    public void nowUnloaded() {
        this.clearMyLocation();
        this.invalidateCaps();
    }
}

